// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a delivery stream.
 */
public class DeliveryStreamDescription private constructor(builder: Builder) {
    /**
     * The date and time that the delivery stream was created.
     */
    public val createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.createTimestamp
    /**
     * The Amazon Resource Name (ARN) of the delivery stream. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
     */
    public val deliveryStreamArn: kotlin.String? = builder.deliveryStreamArn
    /**
     * Indicates the server-side encryption (SSE) status for the delivery stream.
     */
    public val deliveryStreamEncryptionConfiguration: aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration? = builder.deliveryStreamEncryptionConfiguration
    /**
     * The name of the delivery stream.
     */
    public val deliveryStreamName: kotlin.String? = builder.deliveryStreamName
    /**
     * The status of the delivery stream. If the status of a delivery stream is `CREATING_FAILED`, this status doesn't change, and you can't invoke `CreateDeliveryStream` again on it. However, you can invoke the DeleteDeliveryStream operation to delete it.
     */
    public val deliveryStreamStatus: aws.sdk.kotlin.services.firehose.model.DeliveryStreamStatus? = builder.deliveryStreamStatus
    /**
     * The delivery stream type. This can be one of the following values:
     * + `DirectPut`: Provider applications access the delivery stream directly.
     * + `KinesisStreamAsSource`: The delivery stream uses a Kinesis data stream as a source.
     */
    public val deliveryStreamType: aws.sdk.kotlin.services.firehose.model.DeliveryStreamType? = builder.deliveryStreamType
    /**
     * The destinations.
     */
    public val destinations: List<DestinationDescription>? = builder.destinations
    /**
     * Provides details in case one of the following operations fails due to an error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption, StopDeliveryStreamEncryption.
     */
    public val failureDescription: aws.sdk.kotlin.services.firehose.model.FailureDescription? = builder.failureDescription
    /**
     * Indicates whether there are more destinations available to list.
     */
    public val hasMoreDestinations: kotlin.Boolean? = builder.hasMoreDestinations
    /**
     * The date and time that the delivery stream was last updated.
     */
    public val lastUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTimestamp
    /**
     * If the `DeliveryStreamType` parameter is `KinesisStreamAsSource`, a SourceDescription object describing the source Kinesis data stream.
     */
    public val source: aws.sdk.kotlin.services.firehose.model.SourceDescription? = builder.source
    /**
     * Each time the destination is updated for a delivery stream, the version ID is changed, and the current version ID is required when updating the destination. This is so that the service knows it is applying the changes to the correct version of the delivery stream.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DeliveryStreamDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeliveryStreamDescription(")
        append("createTimestamp=$createTimestamp,")
        append("deliveryStreamArn=$deliveryStreamArn,")
        append("deliveryStreamEncryptionConfiguration=$deliveryStreamEncryptionConfiguration,")
        append("deliveryStreamName=$deliveryStreamName,")
        append("deliveryStreamStatus=$deliveryStreamStatus,")
        append("deliveryStreamType=$deliveryStreamType,")
        append("destinations=$destinations,")
        append("failureDescription=$failureDescription,")
        append("hasMoreDestinations=$hasMoreDestinations,")
        append("lastUpdateTimestamp=$lastUpdateTimestamp,")
        append("source=$source,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTimestamp?.hashCode() ?: 0
        result = 31 * result + (deliveryStreamArn?.hashCode() ?: 0)
        result = 31 * result + (deliveryStreamEncryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deliveryStreamName?.hashCode() ?: 0)
        result = 31 * result + (deliveryStreamStatus?.hashCode() ?: 0)
        result = 31 * result + (deliveryStreamType?.hashCode() ?: 0)
        result = 31 * result + (destinations?.hashCode() ?: 0)
        result = 31 * result + (failureDescription?.hashCode() ?: 0)
        result = 31 * result + (hasMoreDestinations?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTimestamp?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeliveryStreamDescription

        if (createTimestamp != other.createTimestamp) return false
        if (deliveryStreamArn != other.deliveryStreamArn) return false
        if (deliveryStreamEncryptionConfiguration != other.deliveryStreamEncryptionConfiguration) return false
        if (deliveryStreamName != other.deliveryStreamName) return false
        if (deliveryStreamStatus != other.deliveryStreamStatus) return false
        if (deliveryStreamType != other.deliveryStreamType) return false
        if (destinations != other.destinations) return false
        if (failureDescription != other.failureDescription) return false
        if (hasMoreDestinations != other.hasMoreDestinations) return false
        if (lastUpdateTimestamp != other.lastUpdateTimestamp) return false
        if (source != other.source) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DeliveryStreamDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time that the delivery stream was created.
         */
        public var createTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the delivery stream. For more information, see [Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
         */
        public var deliveryStreamArn: kotlin.String? = null
        /**
         * Indicates the server-side encryption (SSE) status for the delivery stream.
         */
        public var deliveryStreamEncryptionConfiguration: aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration? = null
        /**
         * The name of the delivery stream.
         */
        public var deliveryStreamName: kotlin.String? = null
        /**
         * The status of the delivery stream. If the status of a delivery stream is `CREATING_FAILED`, this status doesn't change, and you can't invoke `CreateDeliveryStream` again on it. However, you can invoke the DeleteDeliveryStream operation to delete it.
         */
        public var deliveryStreamStatus: aws.sdk.kotlin.services.firehose.model.DeliveryStreamStatus? = null
        /**
         * The delivery stream type. This can be one of the following values:
         * + `DirectPut`: Provider applications access the delivery stream directly.
         * + `KinesisStreamAsSource`: The delivery stream uses a Kinesis data stream as a source.
         */
        public var deliveryStreamType: aws.sdk.kotlin.services.firehose.model.DeliveryStreamType? = null
        /**
         * The destinations.
         */
        public var destinations: List<DestinationDescription>? = null
        /**
         * Provides details in case one of the following operations fails due to an error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption, StopDeliveryStreamEncryption.
         */
        public var failureDescription: aws.sdk.kotlin.services.firehose.model.FailureDescription? = null
        /**
         * Indicates whether there are more destinations available to list.
         */
        public var hasMoreDestinations: kotlin.Boolean? = null
        /**
         * The date and time that the delivery stream was last updated.
         */
        public var lastUpdateTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If the `DeliveryStreamType` parameter is `KinesisStreamAsSource`, a SourceDescription object describing the source Kinesis data stream.
         */
        public var source: aws.sdk.kotlin.services.firehose.model.SourceDescription? = null
        /**
         * Each time the destination is updated for a delivery stream, the version ID is changed, and the current version ID is required when updating the destination. This is so that the service knows it is applying the changes to the correct version of the delivery stream.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DeliveryStreamDescription) : this() {
            this.createTimestamp = x.createTimestamp
            this.deliveryStreamArn = x.deliveryStreamArn
            this.deliveryStreamEncryptionConfiguration = x.deliveryStreamEncryptionConfiguration
            this.deliveryStreamName = x.deliveryStreamName
            this.deliveryStreamStatus = x.deliveryStreamStatus
            this.deliveryStreamType = x.deliveryStreamType
            this.destinations = x.destinations
            this.failureDescription = x.failureDescription
            this.hasMoreDestinations = x.hasMoreDestinations
            this.lastUpdateTimestamp = x.lastUpdateTimestamp
            this.source = x.source
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DeliveryStreamDescription = DeliveryStreamDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration] inside the given [block]
         */
        public fun deliveryStreamEncryptionConfiguration(block: aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.deliveryStreamEncryptionConfiguration = aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.FailureDescription] inside the given [block]
         */
        public fun failureDescription(block: aws.sdk.kotlin.services.firehose.model.FailureDescription.Builder.() -> kotlin.Unit) {
            this.failureDescription = aws.sdk.kotlin.services.firehose.model.FailureDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SourceDescription] inside the given [block]
         */
        public fun source(block: aws.sdk.kotlin.services.firehose.model.SourceDescription.Builder.() -> kotlin.Unit) {
            this.source = aws.sdk.kotlin.services.firehose.model.SourceDescription.invoke(block)
        }
    }
}
