// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes the buffering options that can be applied before data is delivered to the HTTP endpoint destination. Kinesis Data Firehose treats these options as hints, and it might choose to use more optimal values. The `SizeInMBs` and `IntervalInSeconds` parameters are optional. However, if specify a value for one of them, you must also provide a value for the other.
 */
public class HttpEndpointBufferingHints private constructor(builder: Builder) {
    /**
     * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
     */
    public val intervalInSeconds: kotlin.Int? = builder.intervalInSeconds
    /**
     * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
     *
     * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
     */
    public val sizeInMBs: kotlin.Int? = builder.sizeInMBs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpEndpointBufferingHints(")
        append("intervalInSeconds=$intervalInSeconds,")
        append("sizeInMBs=$sizeInMBs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = intervalInSeconds ?: 0
        result = 31 * result + (sizeInMBs ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpEndpointBufferingHints

        if (intervalInSeconds != other.intervalInSeconds) return false
        if (sizeInMBs != other.sizeInMBs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Buffer incoming data for the specified period of time, in seconds, before delivering it to the destination. The default value is 300 (5 minutes).
         */
        public var intervalInSeconds: kotlin.Int? = null
        /**
         * Buffer incoming data to the specified size, in MBs, before delivering it to the destination. The default value is 5.
         *
         * We recommend setting this parameter to a value greater than the amount of data you typically ingest into the delivery stream in 10 seconds. For example, if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
         */
        public var sizeInMBs: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints) : this() {
            this.intervalInSeconds = x.intervalInSeconds
            this.sizeInMBs = x.sizeInMBs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.HttpEndpointBufferingHints = HttpEndpointBufferingHints(this)
    }
}
