// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



public class ListDeliveryStreamsRequest private constructor(builder: Builder) {
    /**
     * The delivery stream type. This can be one of the following values:
     * + `DirectPut`: Provider applications access the delivery stream directly.
     * + `KinesisStreamAsSource`: The delivery stream uses a Kinesis data stream as a source.
     *
     * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
     */
    public val deliveryStreamType: aws.sdk.kotlin.services.firehose.model.DeliveryStreamType? = builder.deliveryStreamType
    /**
     * The list of delivery streams returned by this call to `ListDeliveryStreams` will start with the delivery stream whose name comes alphabetically immediately after the name you specify in `ExclusiveStartDeliveryStreamName`.
     */
    public val exclusiveStartDeliveryStreamName: kotlin.String? = builder.exclusiveStartDeliveryStreamName
    /**
     * The maximum number of delivery streams to list. The default value is 10.
     */
    public val limit: kotlin.Int? = builder.limit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.ListDeliveryStreamsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDeliveryStreamsRequest(")
        append("deliveryStreamType=$deliveryStreamType,")
        append("exclusiveStartDeliveryStreamName=$exclusiveStartDeliveryStreamName,")
        append("limit=$limit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryStreamType?.hashCode() ?: 0
        result = 31 * result + (exclusiveStartDeliveryStreamName?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDeliveryStreamsRequest

        if (deliveryStreamType != other.deliveryStreamType) return false
        if (exclusiveStartDeliveryStreamName != other.exclusiveStartDeliveryStreamName) return false
        if (limit != other.limit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.ListDeliveryStreamsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The delivery stream type. This can be one of the following values:
         * + `DirectPut`: Provider applications access the delivery stream directly.
         * + `KinesisStreamAsSource`: The delivery stream uses a Kinesis data stream as a source.
         *
         * This parameter is optional. If this parameter is omitted, delivery streams of all types are returned.
         */
        public var deliveryStreamType: aws.sdk.kotlin.services.firehose.model.DeliveryStreamType? = null
        /**
         * The list of delivery streams returned by this call to `ListDeliveryStreams` will start with the delivery stream whose name comes alphabetically immediately after the name you specify in `ExclusiveStartDeliveryStreamName`.
         */
        public var exclusiveStartDeliveryStreamName: kotlin.String? = null
        /**
         * The maximum number of delivery streams to list. The default value is 10.
         */
        public var limit: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.ListDeliveryStreamsRequest) : this() {
            this.deliveryStreamType = x.deliveryStreamType
            this.exclusiveStartDeliveryStreamName = x.exclusiveStartDeliveryStreamName
            this.limit = x.limit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.ListDeliveryStreamsRequest = ListDeliveryStreamsRequest(this)
    }
}
