// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Specifies the schema to which you want Kinesis Data Firehose to configure your data before it writes it to Amazon S3. This parameter is required if `Enabled` is set to true.
 */
public class SchemaConfiguration private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services Glue Data Catalog. If you don't supply this, the Amazon Web Services account ID is used by default.
     */
    public val catalogId: kotlin.String? = builder.catalogId
    /**
     * Specifies the name of the Amazon Web Services Glue database that contains the schema for the output data.
     *
     * If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `DatabaseName` property is required and its value must be specified.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * If you don't specify an Amazon Web Services Region, the default is the current Region.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The role that Kinesis Data Firehose can use to access Amazon Web Services Glue. This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren't allowed.
     *
     * If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `RoleARN` property is required and its value must be specified.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * Specifies the Amazon Web Services Glue table that contains the column information that constitutes your data schema.
     *
     * If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `TableName` property is required and its value must be specified.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * Specifies the table version for the output data schema. If you don't specify this version ID, or if you set it to `LATEST`, Kinesis Data Firehose uses the most recent version. This means that any updates to the table are automatically picked up.
     */
    public val versionId: kotlin.String? = builder.versionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.SchemaConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SchemaConfiguration(")
        append("catalogId=$catalogId,")
        append("databaseName=$databaseName,")
        append("region=$region,")
        append("roleArn=$roleArn,")
        append("tableName=$tableName,")
        append("versionId=$versionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogId?.hashCode() ?: 0
        result = 31 * result + (databaseName?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (versionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SchemaConfiguration

        if (catalogId != other.catalogId) return false
        if (databaseName != other.databaseName) return false
        if (region != other.region) return false
        if (roleArn != other.roleArn) return false
        if (tableName != other.tableName) return false
        if (versionId != other.versionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.SchemaConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services Glue Data Catalog. If you don't supply this, the Amazon Web Services account ID is used by default.
         */
        public var catalogId: kotlin.String? = null
        /**
         * Specifies the name of the Amazon Web Services Glue database that contains the schema for the output data.
         *
         * If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `DatabaseName` property is required and its value must be specified.
         */
        public var databaseName: kotlin.String? = null
        /**
         * If you don't specify an Amazon Web Services Region, the default is the current Region.
         */
        public var region: kotlin.String? = null
        /**
         * The role that Kinesis Data Firehose can use to access Amazon Web Services Glue. This role must be in the same account you use for Kinesis Data Firehose. Cross-account roles aren't allowed.
         *
         * If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `RoleARN` property is required and its value must be specified.
         */
        public var roleArn: kotlin.String? = null
        /**
         * Specifies the Amazon Web Services Glue table that contains the column information that constitutes your data schema.
         *
         * If the `SchemaConfiguration` request parameter is used as part of invoking the `CreateDeliveryStream` API, then the `TableName` property is required and its value must be specified.
         */
        public var tableName: kotlin.String? = null
        /**
         * Specifies the table version for the output data schema. If you don't specify this version ID, or if you set it to `LATEST`, Kinesis Data Firehose uses the most recent version. This means that any updates to the table are automatically picked up.
         */
        public var versionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.SchemaConfiguration) : this() {
            this.catalogId = x.catalogId
            this.databaseName = x.databaseName
            this.region = x.region
            this.roleArn = x.roleArn
            this.tableName = x.tableName
            this.versionId = x.versionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.SchemaConfiguration = SchemaConfiguration(this)
    }
}
