// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes a COPY command for Amazon Redshift.
 */
class CopyCommand private constructor(builder: Builder) {
    /**
     * Optional parameters to use with the Amazon Redshift COPY command. For
     * more information, see the "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command. Some possible
     * examples that would apply to Kinesis Data Firehose are as follows:
     *
     * delimiter '\t' lzop; - fields are delimited with "\t" (TAB character) and
     * compressed using lzop.
     *
     * delimiter '|' - fields are delimited with "|" (this is the default
     * delimiter).
     *
     * delimiter '|' escape - the delimiter should be escaped.
     *
     * fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6' -
     * fields are fixed width in the source, with each width specified after every column in the
     * table.
     *
     * JSON 's3://mybucket/jsonpaths.txt' - data is in JSON format, and the path
     * specified is the format of the data.
     * For more examples, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command
     * examples.
     */
    val copyOptions: kotlin.String? = builder.copyOptions
    /**
     * A comma-separated list of column names.
     */
    val dataTableColumns: kotlin.String? = builder.dataTableColumns
    /**
     * The name of the target table. The table must already exist in the database.
     */
    val dataTableName: kotlin.String? = builder.dataTableName

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.CopyCommand = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyCommand(")
        append("copyOptions=$copyOptions,")
        append("dataTableColumns=$dataTableColumns,")
        append("dataTableName=$dataTableName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = copyOptions?.hashCode() ?: 0
        result = 31 * result + (dataTableColumns?.hashCode() ?: 0)
        result = 31 * result + (dataTableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyCommand

        if (copyOptions != other.copyOptions) return false
        if (dataTableColumns != other.dataTableColumns) return false
        if (dataTableName != other.dataTableName) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.CopyCommand = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional parameters to use with the Amazon Redshift COPY command. For
         * more information, see the "Optional Parameters" section of <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html">Amazon Redshift COPY command. Some possible
         * examples that would apply to Kinesis Data Firehose are as follows:
         *
         * delimiter '\t' lzop; - fields are delimited with "\t" (TAB character) and
         * compressed using lzop.
         *
         * delimiter '|' - fields are delimited with "|" (this is the default
         * delimiter).
         *
         * delimiter '|' escape - the delimiter should be escaped.
         *
         * fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6' -
         * fields are fixed width in the source, with each width specified after every column in the
         * table.
         *
         * JSON 's3://mybucket/jsonpaths.txt' - data is in JSON format, and the path
         * specified is the format of the data.
         * For more examples, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html">Amazon Redshift COPY command
         * examples.
         */
        var copyOptions: kotlin.String? = null
        /**
         * A comma-separated list of column names.
         */
        var dataTableColumns: kotlin.String? = null
        /**
         * The name of the target table. The table must already exist in the database.
         */
        var dataTableName: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.CopyCommand) : this() {
            this.copyOptions = x.copyOptions
            this.dataTableColumns = x.dataTableColumns
            this.dataTableName = x.dataTableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.CopyCommand = CopyCommand(this)
    }
}
