// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side
 * Encryption (SSE).
 */
class DeliveryStreamEncryptionConfigurationInput private constructor(builder: Builder) {
    /**
     * If you set KeyType to CUSTOMER_MANAGED_CMK, you must specify
     * the Amazon Resource Name (ARN) of the CMK. If you set KeyType to
     * AWS_OWNED_CMK, Kinesis Data Firehose uses a service-account CMK.
     */
    val keyArn: kotlin.String? = builder.keyArn
    /**
     * Indicates the type of customer master key (CMK) to use for encryption. The default
     * setting is AWS_OWNED_CMK. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
     * Master Keys (CMKs). When you invoke CreateDeliveryStream or
     * StartDeliveryStreamEncryption with KeyType set to
     * CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant to create a grant that allows the Kinesis Data Firehose service to
     * use the customer managed CMK to perform encryption and decryption. Kinesis Data Firehose
     * manages that grant.
     * When you invoke StartDeliveryStreamEncryption to change the CMK for a
     * delivery stream that is encrypted with a customer managed CMK, Kinesis Data Firehose
     * schedules the grant it had on the old CMK for retirement.
     * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If
     * a CreateDeliveryStream or StartDeliveryStreamEncryption
     * operation exceeds this limit, Kinesis Data Firehose throws a
     * LimitExceededException.
     *
     * To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't
     * support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About
     * Symmetric and Asymmetric CMKs in the AWS Key Management Service developer
     * guide.
     */
    val keyType: aws.sdk.kotlin.services.firehose.model.KeyType? = builder.keyType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfigurationInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeliveryStreamEncryptionConfigurationInput(")
        append("keyArn=$keyArn,")
        append("keyType=$keyType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyArn?.hashCode() ?: 0
        result = 31 * result + (keyType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeliveryStreamEncryptionConfigurationInput

        if (keyArn != other.keyArn) return false
        if (keyType != other.keyType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfigurationInput = Builder(this).apply(block).build()

    class Builder {
        /**
         * If you set KeyType to CUSTOMER_MANAGED_CMK, you must specify
         * the Amazon Resource Name (ARN) of the CMK. If you set KeyType to
         * AWS_OWNED_CMK, Kinesis Data Firehose uses a service-account CMK.
         */
        var keyArn: kotlin.String? = null
        /**
         * Indicates the type of customer master key (CMK) to use for encryption. The default
         * setting is AWS_OWNED_CMK. For more information about CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys">Customer
         * Master Keys (CMKs). When you invoke CreateDeliveryStream or
         * StartDeliveryStreamEncryption with KeyType set to
         * CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon KMS operation <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html">CreateGrant to create a grant that allows the Kinesis Data Firehose service to
         * use the customer managed CMK to perform encryption and decryption. Kinesis Data Firehose
         * manages that grant.
         * When you invoke StartDeliveryStreamEncryption to change the CMK for a
         * delivery stream that is encrypted with a customer managed CMK, Kinesis Data Firehose
         * schedules the grant it had on the old CMK for retirement.
         * You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery streams. If
         * a CreateDeliveryStream or StartDeliveryStreamEncryption
         * operation exceeds this limit, Kinesis Data Firehose throws a
         * LimitExceededException.
         *
         * To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose doesn't
         * support asymmetric CMKs. For information about symmetric and asymmetric CMKs, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html">About
         * Symmetric and Asymmetric CMKs in the AWS Key Management Service developer
         * guide.
         */
        var keyType: aws.sdk.kotlin.services.firehose.model.KeyType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfigurationInput) : this() {
            this.keyArn = x.keyArn
            this.keyType = x.keyType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DeliveryStreamEncryptionConfigurationInput = DeliveryStreamEncryptionConfigurationInput(this)
    }
}
