// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes the configuration of a destination in Amazon ES.
 */
class ElasticsearchDestinationConfiguration private constructor(builder: Builder) {
    /**
     * The buffering options. If no value is specified, the default values for
     * ElasticsearchBufferingHints are used.
     */
    val bufferingHints: aws.sdk.kotlin.services.firehose.model.ElasticsearchBufferingHints? = builder.bufferingHints
    /**
     * The Amazon CloudWatch logging options for your delivery stream.
     */
    val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The endpoint to use when communicating with the cluster. Specify either this
     * ClusterEndpoint or the DomainARN field.
     */
    val clusterEndpoint: kotlin.String? = builder.clusterEndpoint
    /**
     * The ARN of the Amazon ES domain. The IAM role must have permissions
     * for DescribeElasticsearchDomain, DescribeElasticsearchDomains,
     * and DescribeElasticsearchDomainConfig after assuming the role specified in
     * RoleARN. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs) and AWS Service Namespaces.
     *
     * Specify either ClusterEndpoint or DomainARN.
     */
    val domainArn: kotlin.String? = builder.domainArn
    /**
     * The Elasticsearch index name.
     */
    val indexName: kotlin.String? = builder.indexName
    /**
     * The Elasticsearch index rotation period. Index rotation appends a timestamp to the
     * IndexName to facilitate the expiration of old data. For more information,
     * see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
     * Amazon ES Destination. The default value is OneDay.
     */
    val indexRotationPeriod: aws.sdk.kotlin.services.firehose.model.ElasticsearchIndexRotationPeriod? = builder.indexRotationPeriod
    /**
     * The data processing configuration.
     */
    val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
     * Amazon ES. The default value is 300 (5 minutes).
     */
    val retryOptions: aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
     * for calling the Amazon ES Configuration API and for indexing documents. For more
     * information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
     * Firehose Access to an Amazon S3 Destination and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
     * AWS Service Namespaces.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * Defines how documents should be delivered to Amazon S3. When it is set to
     * FailedDocumentsOnly, Kinesis Data Firehose writes any documents that could
     * not be indexed to the configured Amazon S3 destination, with
     * elasticsearch-failed/ appended to the key prefix. When set to
     * AllDocuments, Kinesis Data Firehose delivers all incoming records to Amazon
     * S3, and also writes failed documents with elasticsearch-failed/ appended to
     * the prefix. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for the
     * Amazon ES Destination. Default value is
     * FailedDocumentsOnly.
     * You can't change this backup mode after you create the delivery stream.
     */
    val s3BackupMode: aws.sdk.kotlin.services.firehose.model.ElasticsearchS3BackupMode? = builder.s3BackupMode
    /**
     * The configuration for the backup Amazon S3 location.
     */
    val s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = builder.s3Configuration
    /**
     * The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
     * index. If you try to specify a new type for an existing index that already has another
     * type, Kinesis Data Firehose returns an error during run time.
     *
     * For Elasticsearch 7.x, don't specify a TypeName.
     */
    val typeName: kotlin.String? = builder.typeName
    /**
     * The details of the VPC of the Amazon ES destination.
     */
    val vpcConfiguration: aws.sdk.kotlin.services.firehose.model.VpcConfiguration? = builder.vpcConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.ElasticsearchDestinationConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ElasticsearchDestinationConfiguration(")
        append("bufferingHints=$bufferingHints,")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("clusterEndpoint=$clusterEndpoint,")
        append("domainArn=$domainArn,")
        append("indexName=$indexName,")
        append("indexRotationPeriod=$indexRotationPeriod,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3Configuration=$s3Configuration,")
        append("typeName=$typeName,")
        append("vpcConfiguration=$vpcConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bufferingHints?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLoggingOptions?.hashCode() ?: 0)
        result = 31 * result + (clusterEndpoint?.hashCode() ?: 0)
        result = 31 * result + (domainArn?.hashCode() ?: 0)
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (indexRotationPeriod?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3Configuration?.hashCode() ?: 0)
        result = 31 * result + (typeName?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ElasticsearchDestinationConfiguration

        if (bufferingHints != other.bufferingHints) return false
        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (clusterEndpoint != other.clusterEndpoint) return false
        if (domainArn != other.domainArn) return false
        if (indexName != other.indexName) return false
        if (indexRotationPeriod != other.indexRotationPeriod) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3Configuration != other.s3Configuration) return false
        if (typeName != other.typeName) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.ElasticsearchDestinationConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The buffering options. If no value is specified, the default values for
         * ElasticsearchBufferingHints are used.
         */
        var bufferingHints: aws.sdk.kotlin.services.firehose.model.ElasticsearchBufferingHints? = null
        /**
         * The Amazon CloudWatch logging options for your delivery stream.
         */
        var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The endpoint to use when communicating with the cluster. Specify either this
         * ClusterEndpoint or the DomainARN field.
         */
        var clusterEndpoint: kotlin.String? = null
        /**
         * The ARN of the Amazon ES domain. The IAM role must have permissions
         * for DescribeElasticsearchDomain, DescribeElasticsearchDomains,
         * and DescribeElasticsearchDomainConfig after assuming the role specified in
         * RoleARN. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs) and AWS Service Namespaces.
         *
         * Specify either ClusterEndpoint or DomainARN.
         */
        var domainArn: kotlin.String? = null
        /**
         * The Elasticsearch index name.
         */
        var indexName: kotlin.String? = null
        /**
         * The Elasticsearch index rotation period. Index rotation appends a timestamp to the
         * IndexName to facilitate the expiration of old data. For more information,
         * see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation">Index Rotation for the
         * Amazon ES Destination. The default value is OneDay.
         */
        var indexRotationPeriod: aws.sdk.kotlin.services.firehose.model.ElasticsearchIndexRotationPeriod? = null
        /**
         * The data processing configuration.
         */
        var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
         * Amazon ES. The default value is 300 (5 minutes).
         */
        var retryOptions: aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data Firehose
         * for calling the Amazon ES Configuration API and for indexing documents. For more
         * information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3">Grant Kinesis Data
         * Firehose Access to an Amazon S3 Destination and <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and
         * AWS Service Namespaces.
         */
        var roleArn: kotlin.String? = null
        /**
         * Defines how documents should be delivered to Amazon S3. When it is set to
         * FailedDocumentsOnly, Kinesis Data Firehose writes any documents that could
         * not be indexed to the configured Amazon S3 destination, with
         * elasticsearch-failed/ appended to the key prefix. When set to
         * AllDocuments, Kinesis Data Firehose delivers all incoming records to Amazon
         * S3, and also writes failed documents with elasticsearch-failed/ appended to
         * the prefix. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup">Amazon S3 Backup for the
         * Amazon ES Destination. Default value is
         * FailedDocumentsOnly.
         * You can't change this backup mode after you create the delivery stream.
         */
        var s3BackupMode: aws.sdk.kotlin.services.firehose.model.ElasticsearchS3BackupMode? = null
        /**
         * The configuration for the backup Amazon S3 location.
         */
        var s3Configuration: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration? = null
        /**
         * The Elasticsearch type name. For Elasticsearch 6.x, there can be only one type per
         * index. If you try to specify a new type for an existing index that already has another
         * type, Kinesis Data Firehose returns an error during run time.
         *
         * For Elasticsearch 7.x, don't specify a TypeName.
         */
        var typeName: kotlin.String? = null
        /**
         * The details of the VPC of the Amazon ES destination.
         */
        var vpcConfiguration: aws.sdk.kotlin.services.firehose.model.VpcConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.ElasticsearchDestinationConfiguration) : this() {
            this.bufferingHints = x.bufferingHints
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.clusterEndpoint = x.clusterEndpoint
            this.domainArn = x.domainArn
            this.indexName = x.indexName
            this.indexRotationPeriod = x.indexRotationPeriod
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3Configuration = x.s3Configuration
            this.typeName = x.typeName
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.ElasticsearchDestinationConfiguration = ElasticsearchDestinationConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ElasticsearchBufferingHints] inside the given [block]
         */
        fun bufferingHints(block: aws.sdk.kotlin.services.firehose.model.ElasticsearchBufferingHints.Builder.() -> kotlin.Unit) {
            this.bufferingHints = aws.sdk.kotlin.services.firehose.model.ElasticsearchBufferingHints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions] inside the given [block]
         */
        fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration] inside the given [block]
         */
        fun s3Configuration(block: aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.Builder.() -> kotlin.Unit) {
            this.s3Configuration = aws.sdk.kotlin.services.firehose.model.S3DestinationConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.VpcConfiguration] inside the given [block]
         */
        fun vpcConfiguration(block: aws.sdk.kotlin.services.firehose.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.firehose.model.VpcConfiguration.invoke(block)
        }
    }
}
