// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details about a Kinesis data stream used as the source for a Kinesis Data Firehose
 * delivery stream.
 */
class KinesisStreamSourceDescription private constructor(builder: Builder) {
    /**
     * Kinesis Data Firehose starts retrieving records from the Kinesis data stream starting
     * with this timestamp.
     */
    val deliveryStartTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.deliveryStartTimestamp
    /**
     * The Amazon Resource Name (ARN) of the source Kinesis data stream. For more
     * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
     * Kinesis Data Streams ARN Format.
     */
    val kinesisStreamArn: kotlin.String? = builder.kinesisStreamArn
    /**
     * The ARN of the role used by the source Kinesis data stream. For more information, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
     * Access Management (IAM) ARN Format.
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisStreamSourceDescription(")
        append("deliveryStartTimestamp=$deliveryStartTimestamp,")
        append("kinesisStreamArn=$kinesisStreamArn,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deliveryStartTimestamp?.hashCode() ?: 0
        result = 31 * result + (kinesisStreamArn?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisStreamSourceDescription

        if (deliveryStartTimestamp != other.deliveryStartTimestamp) return false
        if (kinesisStreamArn != other.kinesisStreamArn) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * Kinesis Data Firehose starts retrieving records from the Kinesis data stream starting
         * with this timestamp.
         */
        var deliveryStartTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the source Kinesis data stream. For more
         * information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams">Amazon
         * Kinesis Data Streams ARN Format.
         */
        var kinesisStreamArn: kotlin.String? = null
        /**
         * The ARN of the role used by the source Kinesis data stream. For more information, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">AWS Identity and
         * Access Management (IAM) ARN Format.
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription) : this() {
            this.deliveryStartTimestamp = x.deliveryStartTimestamp
            this.kinesisStreamArn = x.kinesisStreamArn
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.KinesisStreamSourceDescription = KinesisStreamSourceDescription(this)
    }
}
