// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes a destination in Amazon Redshift.
 */
class RedshiftDestinationDescription private constructor(builder: Builder) {
    /**
     * The Amazon CloudWatch logging options for your delivery stream.
     */
    val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The database connection string.
     */
    val clusterJdbcurl: kotlin.String? = builder.clusterJdbcurl
    /**
     * The COPY command.
     */
    val copyCommand: aws.sdk.kotlin.services.firehose.model.CopyCommand? = builder.copyCommand
    /**
     * The data processing configuration.
     */
    val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
     * Amazon Redshift. Default value is 3600 (60 minutes).
     */
    val retryOptions: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs) and AWS Service Namespaces.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The configuration for backup in Amazon S3.
     */
    val s3BackupDescription: aws.sdk.kotlin.services.firehose.model.S3DestinationDescription? = builder.s3BackupDescription
    /**
     * The Amazon S3 backup mode.
     */
    val s3BackupMode: aws.sdk.kotlin.services.firehose.model.RedshiftS3BackupMode? = builder.s3BackupMode
    /**
     * The Amazon S3 destination.
     */
    val s3DestinationDescription: aws.sdk.kotlin.services.firehose.model.S3DestinationDescription? = builder.s3DestinationDescription
    /**
     * The name of the user.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDestinationDescription(")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("clusterJdbcurl=$clusterJdbcurl,")
        append("copyCommand=$copyCommand,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupDescription=$s3BackupDescription,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3DestinationDescription=$s3DestinationDescription,")
        append("username=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLoggingOptions?.hashCode() ?: 0
        result = 31 * result + (clusterJdbcurl?.hashCode() ?: 0)
        result = 31 * result + (copyCommand?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupDescription?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3DestinationDescription?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDestinationDescription

        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (clusterJdbcurl != other.clusterJdbcurl) return false
        if (copyCommand != other.copyCommand) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupDescription != other.s3BackupDescription) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3DestinationDescription != other.s3DestinationDescription) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon CloudWatch logging options for your delivery stream.
         */
        var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The database connection string.
         */
        var clusterJdbcurl: kotlin.String? = null
        /**
         * The COPY command.
         */
        var copyCommand: aws.sdk.kotlin.services.firehose.model.CopyCommand? = null
        /**
         * The data processing configuration.
         */
        var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
         * Amazon Redshift. Default value is 3600 (60 minutes).
         */
        var retryOptions: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs) and AWS Service Namespaces.
         */
        var roleArn: kotlin.String? = null
        /**
         * The configuration for backup in Amazon S3.
         */
        var s3BackupDescription: aws.sdk.kotlin.services.firehose.model.S3DestinationDescription? = null
        /**
         * The Amazon S3 backup mode.
         */
        var s3BackupMode: aws.sdk.kotlin.services.firehose.model.RedshiftS3BackupMode? = null
        /**
         * The Amazon S3 destination.
         */
        var s3DestinationDescription: aws.sdk.kotlin.services.firehose.model.S3DestinationDescription? = null
        /**
         * The name of the user.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.RedshiftDestinationDescription) : this() {
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.clusterJdbcurl = x.clusterJdbcurl
            this.copyCommand = x.copyCommand
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupDescription = x.s3BackupDescription
            this.s3BackupMode = x.s3BackupMode
            this.s3DestinationDescription = x.s3DestinationDescription
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationDescription = RedshiftDestinationDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CopyCommand] inside the given [block]
         */
        fun copyCommand(block: aws.sdk.kotlin.services.firehose.model.CopyCommand.Builder.() -> kotlin.Unit) {
            this.copyCommand = aws.sdk.kotlin.services.firehose.model.CopyCommand.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions] inside the given [block]
         */
        fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationDescription] inside the given [block]
         */
        fun s3BackupDescription(block: aws.sdk.kotlin.services.firehose.model.S3DestinationDescription.Builder.() -> kotlin.Unit) {
            this.s3BackupDescription = aws.sdk.kotlin.services.firehose.model.S3DestinationDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationDescription] inside the given [block]
         */
        fun s3DestinationDescription(block: aws.sdk.kotlin.services.firehose.model.S3DestinationDescription.Builder.() -> kotlin.Unit) {
            this.s3DestinationDescription = aws.sdk.kotlin.services.firehose.model.S3DestinationDescription.invoke(block)
        }
    }
}
