// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes an update for a destination in Amazon Redshift.
 */
class RedshiftDestinationUpdate private constructor(builder: Builder) {
    /**
     * The Amazon CloudWatch logging options for your delivery stream.
     */
    val cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = builder.cloudWatchLoggingOptions
    /**
     * The database connection string.
     */
    val clusterJdbcurl: kotlin.String? = builder.clusterJdbcurl
    /**
     * The COPY command.
     */
    val copyCommand: aws.sdk.kotlin.services.firehose.model.CopyCommand? = builder.copyCommand
    /**
     * The user password.
     */
    val password: kotlin.String? = builder.password
    /**
     * The data processing configuration.
     */
    val processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
     * Amazon Redshift. Default value is 3600 (60 minutes).
     */
    val retryOptions: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions? = builder.retryOptions
    /**
     * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
     * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
     * Resource Names (ARNs) and AWS Service Namespaces.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
     * backup is enabled, you can't update the delivery stream to disable it.
     */
    val s3BackupMode: aws.sdk.kotlin.services.firehose.model.RedshiftS3BackupMode? = builder.s3BackupMode
    /**
     * The Amazon S3 destination for backup.
     */
    val s3BackupUpdate: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = builder.s3BackupUpdate
    /**
     * The Amazon S3 destination.
     * The compression formats SNAPPY or ZIP cannot be specified
     * in RedshiftDestinationUpdate.S3Update because the Amazon Redshift
     * COPY operation that reads from the S3 bucket doesn't support these
     * compression formats.
     */
    val s3Update: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = builder.s3Update
    /**
     * The name of the user.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDestinationUpdate(")
        append("cloudWatchLoggingOptions=$cloudWatchLoggingOptions,")
        append("clusterJdbcurl=$clusterJdbcurl,")
        append("copyCommand=$copyCommand,")
        append("password=*** Sensitive Data Redacted ***,")
        append("processingConfiguration=$processingConfiguration,")
        append("retryOptions=$retryOptions,")
        append("roleArn=$roleArn,")
        append("s3BackupMode=$s3BackupMode,")
        append("s3BackupUpdate=$s3BackupUpdate,")
        append("s3Update=$s3Update,")
        append("username=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLoggingOptions?.hashCode() ?: 0
        result = 31 * result + (clusterJdbcurl?.hashCode() ?: 0)
        result = 31 * result + (copyCommand?.hashCode() ?: 0)
        result = 31 * result + (password?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (retryOptions?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3BackupMode?.hashCode() ?: 0)
        result = 31 * result + (s3BackupUpdate?.hashCode() ?: 0)
        result = 31 * result + (s3Update?.hashCode() ?: 0)
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDestinationUpdate

        if (cloudWatchLoggingOptions != other.cloudWatchLoggingOptions) return false
        if (clusterJdbcurl != other.clusterJdbcurl) return false
        if (copyCommand != other.copyCommand) return false
        if (password != other.password) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (retryOptions != other.retryOptions) return false
        if (roleArn != other.roleArn) return false
        if (s3BackupMode != other.s3BackupMode) return false
        if (s3BackupUpdate != other.s3BackupUpdate) return false
        if (s3Update != other.s3Update) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationUpdate = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon CloudWatch logging options for your delivery stream.
         */
        var cloudWatchLoggingOptions: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions? = null
        /**
         * The database connection string.
         */
        var clusterJdbcurl: kotlin.String? = null
        /**
         * The COPY command.
         */
        var copyCommand: aws.sdk.kotlin.services.firehose.model.CopyCommand? = null
        /**
         * The user password.
         */
        var password: kotlin.String? = null
        /**
         * The data processing configuration.
         */
        var processingConfiguration: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration? = null
        /**
         * The retry behavior in case Kinesis Data Firehose is unable to deliver documents to
         * Amazon Redshift. Default value is 3600 (60 minutes).
         */
        var retryOptions: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions? = null
        /**
         * The Amazon Resource Name (ARN) of the AWS credentials. For more information, see
         * <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon
         * Resource Names (ARNs) and AWS Service Namespaces.
         */
        var roleArn: kotlin.String? = null
        /**
         * You can update a delivery stream to enable Amazon S3 backup if it is disabled. If
         * backup is enabled, you can't update the delivery stream to disable it.
         */
        var s3BackupMode: aws.sdk.kotlin.services.firehose.model.RedshiftS3BackupMode? = null
        /**
         * The Amazon S3 destination for backup.
         */
        var s3BackupUpdate: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = null
        /**
         * The Amazon S3 destination.
         * The compression formats SNAPPY or ZIP cannot be specified
         * in RedshiftDestinationUpdate.S3Update because the Amazon Redshift
         * COPY operation that reads from the S3 bucket doesn't support these
         * compression formats.
         */
        var s3Update: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate? = null
        /**
         * The name of the user.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.RedshiftDestinationUpdate) : this() {
            this.cloudWatchLoggingOptions = x.cloudWatchLoggingOptions
            this.clusterJdbcurl = x.clusterJdbcurl
            this.copyCommand = x.copyCommand
            this.password = x.password
            this.processingConfiguration = x.processingConfiguration
            this.retryOptions = x.retryOptions
            this.roleArn = x.roleArn
            this.s3BackupMode = x.s3BackupMode
            this.s3BackupUpdate = x.s3BackupUpdate
            this.s3Update = x.s3Update
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.RedshiftDestinationUpdate = RedshiftDestinationUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions] inside the given [block]
         */
        fun cloudWatchLoggingOptions(block: aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.Builder.() -> kotlin.Unit) {
            this.cloudWatchLoggingOptions = aws.sdk.kotlin.services.firehose.model.CloudWatchLoggingOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.CopyCommand] inside the given [block]
         */
        fun copyCommand(block: aws.sdk.kotlin.services.firehose.model.CopyCommand.Builder.() -> kotlin.Unit) {
            this.copyCommand = aws.sdk.kotlin.services.firehose.model.CopyCommand.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration] inside the given [block]
         */
        fun processingConfiguration(block: aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.Builder.() -> kotlin.Unit) {
            this.processingConfiguration = aws.sdk.kotlin.services.firehose.model.ProcessingConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions] inside the given [block]
         */
        fun retryOptions(block: aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions.Builder.() -> kotlin.Unit) {
            this.retryOptions = aws.sdk.kotlin.services.firehose.model.RedshiftRetryOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate] inside the given [block]
         */
        fun s3BackupUpdate(block: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.Builder.() -> kotlin.Unit) {
            this.s3BackupUpdate = aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate] inside the given [block]
         */
        fun s3Update(block: aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.Builder.() -> kotlin.Unit) {
            this.s3Update = aws.sdk.kotlin.services.firehose.model.S3DestinationUpdate.invoke(block)
        }
    }
}
