// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Configures retry behavior in case Kinesis Data Firehose is unable to deliver
 * documents to Splunk, or if it doesn't receive an acknowledgment from Splunk.
 */
class SplunkRetryOptions private constructor(builder: Builder) {
    /**
     * The total amount of time that Kinesis Data Firehose spends on retries. This duration
     * starts after the initial attempt to send data to Splunk fails. It doesn't include the
     * periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each
     * attempt.
     */
    val durationInSeconds: kotlin.Int? = builder.durationInSeconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.SplunkRetryOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SplunkRetryOptions(")
        append("durationInSeconds=$durationInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInSeconds ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SplunkRetryOptions

        if (durationInSeconds != other.durationInSeconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.SplunkRetryOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * The total amount of time that Kinesis Data Firehose spends on retries. This duration
         * starts after the initial attempt to send data to Splunk fails. It doesn't include the
         * periods during which Kinesis Data Firehose waits for acknowledgment from Splunk after each
         * attempt.
         */
        var durationInSeconds: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.SplunkRetryOptions) : this() {
            this.durationInSeconds = x.durationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.SplunkRetryOptions = SplunkRetryOptions(this)
    }
}
