// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * The details of the VPC of the Amazon ES destination.
 */
class VpcConfigurationDescription private constructor(builder: Builder) {
    /**
     * The ARN of the IAM role that the delivery stream uses to create endpoints in the
     * destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can
     * specify a new role. In either case, make sure that the role trusts the Kinesis Data
     * Firehose service principal and that it grants the following permissions:
     *
     *
     *
     * ec2:DescribeVpcs
     *
     *
     *
     * ec2:DescribeVpcAttribute
     *
     *
     *
     * ec2:DescribeSubnets
     *
     *
     *
     * ec2:DescribeSecurityGroups
     *
     *
     *
     * ec2:DescribeNetworkInterfaces
     *
     *
     *
     * ec2:CreateNetworkInterface
     *
     *
     *
     * ec2:CreateNetworkInterfacePermission
     *
     *
     *
     * ec2:DeleteNetworkInterface
     *
     *
     *
     * If you revoke these permissions after you create the delivery stream, Kinesis Data
     * Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
     * degradation in performance.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in
     * the VPC of the Amazon ES destination. You can use the same security group that the Amazon
     * ES domain uses or different ones. If you specify different security groups, ensure that
     * they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure
     * that the Amazon ES domain's security group allows HTTPS traffic from the security groups
     * specified here. If you use the same security group for both your delivery stream and the
     * Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic. For more
     * information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
     * rules in the Amazon VPC documentation.
     */
    val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the
     * Amazon ES destination. Make sure that the routing tables and inbound and outbound rules
     * allow traffic to flow from the subnets whose IDs are specified here to the subnets that
     * have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in
     * each of the subnets that are specified here. Do not delete or modify these ENIs.
     * The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
     * scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
     * scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
     * help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
     * three ENIs for this delivery stream for each of the subnets specified here. For more
     * information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
     * in the Amazon VPC Quotas topic.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The ID of the Amazon ES destination's VPC.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.VpcConfigurationDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfigurationDescription(")
        append("roleArn=$roleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = roleArn?.hashCode() ?: 0
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfigurationDescription

        if (roleArn != other.roleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.VpcConfigurationDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of the IAM role that the delivery stream uses to create endpoints in the
         * destination VPC. You can use your existing Kinesis Data Firehose delivery role or you can
         * specify a new role. In either case, make sure that the role trusts the Kinesis Data
         * Firehose service principal and that it grants the following permissions:
         *
         *
         *
         * ec2:DescribeVpcs
         *
         *
         *
         * ec2:DescribeVpcAttribute
         *
         *
         *
         * ec2:DescribeSubnets
         *
         *
         *
         * ec2:DescribeSecurityGroups
         *
         *
         *
         * ec2:DescribeNetworkInterfaces
         *
         *
         *
         * ec2:CreateNetworkInterface
         *
         *
         *
         * ec2:CreateNetworkInterfacePermission
         *
         *
         *
         * ec2:DeleteNetworkInterface
         *
         *
         *
         * If you revoke these permissions after you create the delivery stream, Kinesis Data
         * Firehose can't scale out by creating more ENIs when necessary. You might therefore see a
         * degradation in performance.
         */
        var roleArn: kotlin.String? = null
        /**
         * The IDs of the security groups that Kinesis Data Firehose uses when it creates ENIs in
         * the VPC of the Amazon ES destination. You can use the same security group that the Amazon
         * ES domain uses or different ones. If you specify different security groups, ensure that
         * they allow outbound HTTPS traffic to the Amazon ES domain's security group. Also ensure
         * that the Amazon ES domain's security group allows HTTPS traffic from the security groups
         * specified here. If you use the same security group for both your delivery stream and the
         * Amazon ES domain, make sure the security group inbound rule allows HTTPS traffic. For more
         * information about security group rules, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules">Security group
         * rules in the Amazon VPC documentation.
         */
        var securityGroupIds: List<String>? = null
        /**
         * The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in the VPC of the
         * Amazon ES destination. Make sure that the routing tables and inbound and outbound rules
         * allow traffic to flow from the subnets whose IDs are specified here to the subnets that
         * have the destination Amazon ES endpoints. Kinesis Data Firehose creates at least one ENI in
         * each of the subnets that are specified here. Do not delete or modify these ENIs.
         * The number of ENIs that Kinesis Data Firehose creates in the subnets specified here
         * scales up and down automatically based on throughput. To enable Kinesis Data Firehose to
         * scale up the number of ENIs to match throughput, ensure that you have sufficient quota. To
         * help you calculate the quota you need, assume that Kinesis Data Firehose can create up to
         * three ENIs for this delivery stream for each of the subnets specified here. For more
         * information about ENI quota, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis">Network Interfaces
         * in the Amazon VPC Quotas topic.
         */
        var subnetIds: List<String>? = null
        /**
         * The ID of the Amazon ES destination's VPC.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.VpcConfigurationDescription) : this() {
            this.roleArn = x.roleArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.VpcConfigurationDescription = VpcConfigurationDescription(this)
    }
}
