// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Specifies that you want Kinesis Data Firehose to convert data from the JSON format to
 * the Parquet or ORC format before writing it to Amazon S3. Kinesis Data Firehose uses the
 * serializer and deserializer that you specify, in addition to the column information from
 * the AWS Glue table, to deserialize your input data from JSON and then serialize it to the
 * Parquet or ORC format. For more information, see <a href="https://docs.aws.amazon.com/firehose/latest/dev/record-format-conversion.html">Kinesis Data Firehose Record
 * Format Conversion.
 */
class DataFormatConversionConfiguration private constructor(builder: Builder) {
    /**
     * Defaults to true. Set it to false if you want to disable
     * format conversion while preserving the configuration details.
     */
    val enabled: kotlin.Boolean? = builder.enabled
    /**
     * Specifies the deserializer that you want Kinesis Data Firehose to use to convert the
     * format of your data from JSON. This parameter is required if Enabled is set to
     * true.
     */
    val inputFormatConfiguration: aws.sdk.kotlin.services.firehose.model.InputFormatConfiguration? = builder.inputFormatConfiguration
    /**
     * Specifies the serializer that you want Kinesis Data Firehose to use to convert the
     * format of your data to the Parquet or ORC format. This parameter is required if
     * Enabled is set to true.
     */
    val outputFormatConfiguration: aws.sdk.kotlin.services.firehose.model.OutputFormatConfiguration? = builder.outputFormatConfiguration
    /**
     * Specifies the AWS Glue Data Catalog table that contains the column information. This
     * parameter is required if Enabled is set to true.
     */
    val schemaConfiguration: aws.sdk.kotlin.services.firehose.model.SchemaConfiguration? = builder.schemaConfiguration

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataFormatConversionConfiguration(")
        append("enabled=$enabled,")
        append("inputFormatConfiguration=$inputFormatConfiguration,")
        append("outputFormatConfiguration=$outputFormatConfiguration,")
        append("schemaConfiguration=$schemaConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enabled?.hashCode() ?: 0
        result = 31 * result + (inputFormatConfiguration?.hashCode() ?: 0)
        result = 31 * result + (outputFormatConfiguration?.hashCode() ?: 0)
        result = 31 * result + (schemaConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataFormatConversionConfiguration

        if (enabled != other.enabled) return false
        if (inputFormatConfiguration != other.inputFormatConfiguration) return false
        if (outputFormatConfiguration != other.outputFormatConfiguration) return false
        if (schemaConfiguration != other.schemaConfiguration) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Defaults to true. Set it to false if you want to disable
         * format conversion while preserving the configuration details.
         */
        var enabled: kotlin.Boolean? = null
        /**
         * Specifies the deserializer that you want Kinesis Data Firehose to use to convert the
         * format of your data from JSON. This parameter is required if Enabled is set to
         * true.
         */
        var inputFormatConfiguration: aws.sdk.kotlin.services.firehose.model.InputFormatConfiguration? = null
        /**
         * Specifies the serializer that you want Kinesis Data Firehose to use to convert the
         * format of your data to the Parquet or ORC format. This parameter is required if
         * Enabled is set to true.
         */
        var outputFormatConfiguration: aws.sdk.kotlin.services.firehose.model.OutputFormatConfiguration? = null
        /**
         * Specifies the AWS Glue Data Catalog table that contains the column information. This
         * parameter is required if Enabled is set to true.
         */
        var schemaConfiguration: aws.sdk.kotlin.services.firehose.model.SchemaConfiguration? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration) : this() {
            this.enabled = x.enabled
            this.inputFormatConfiguration = x.inputFormatConfiguration
            this.outputFormatConfiguration = x.outputFormatConfiguration
            this.schemaConfiguration = x.schemaConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.DataFormatConversionConfiguration = DataFormatConversionConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.InputFormatConfiguration] inside the given [block]
         */
        fun inputFormatConfiguration(block: aws.sdk.kotlin.services.firehose.model.InputFormatConfiguration.Builder.() -> kotlin.Unit) {
            this.inputFormatConfiguration = aws.sdk.kotlin.services.firehose.model.InputFormatConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.OutputFormatConfiguration] inside the given [block]
         */
        fun outputFormatConfiguration(block: aws.sdk.kotlin.services.firehose.model.OutputFormatConfiguration.Builder.() -> kotlin.Unit) {
            this.outputFormatConfiguration = aws.sdk.kotlin.services.firehose.model.OutputFormatConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.firehose.model.SchemaConfiguration] inside the given [block]
         */
        fun schemaConfiguration(block: aws.sdk.kotlin.services.firehose.model.SchemaConfiguration.Builder.() -> kotlin.Unit) {
            this.schemaConfiguration = aws.sdk.kotlin.services.firehose.model.SchemaConfiguration.invoke(block)
        }
    }
}
