// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Configures retry behavior in case Kinesis Data Firehose is unable to deliver
 * documents to Amazon ES.
 */
class ElasticsearchRetryOptions private constructor(builder: Builder) {
    /**
     * After an initial failure to deliver to Amazon ES, the total amount of time during
     * which Kinesis Data Firehose retries delivery (including the first attempt). After this time
     * has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5
     * minutes). A value of 0 (zero) results in no retries.
     */
    val durationInSeconds: kotlin.Int? = builder.durationInSeconds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ElasticsearchRetryOptions(")
        append("durationInSeconds=$durationInSeconds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = durationInSeconds ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ElasticsearchRetryOptions

        if (durationInSeconds != other.durationInSeconds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * After an initial failure to deliver to Amazon ES, the total amount of time during
         * which Kinesis Data Firehose retries delivery (including the first attempt). After this time
         * has elapsed, the failed documents are written to Amazon S3. Default value is 300 seconds (5
         * minutes). A value of 0 (zero) results in no retries.
         */
        var durationInSeconds: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions) : this() {
            this.durationInSeconds = x.durationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.ElasticsearchRetryOptions = ElasticsearchRetryOptions(this)
    }
}
