// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * Describes the configuration of the HTTP endpoint to which Kinesis Firehose delivers
 * data.
 */
class HttpEndpointConfiguration private constructor(builder: Builder) {
    /**
     * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint
     * selected as the destination.
     */
    val accessKey: kotlin.String? = builder.accessKey
    /**
     * The name of the HTTP endpoint selected as the destination.
     */
    val name: kotlin.String? = builder.name
    /**
     * The URL of the HTTP endpoint selected as the destination.
     *
     * If you choose an HTTP endpoint as your destination, review and follow the
     * instructions in the <a href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP Endpoint
     * Delivery Request and Response Specifications.
     */
    val url: kotlin.String? = builder.url

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpEndpointConfiguration(")
        append("accessKey=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("url=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKey?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpEndpointConfiguration

        if (accessKey != other.accessKey) return false
        if (name != other.name) return false
        if (url != other.url) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * The access key required for Kinesis Firehose to authenticate with the HTTP endpoint
         * selected as the destination.
         */
        var accessKey: kotlin.String? = null
        /**
         * The name of the HTTP endpoint selected as the destination.
         */
        var name: kotlin.String? = null
        /**
         * The URL of the HTTP endpoint selected as the destination.
         *
         * If you choose an HTTP endpoint as your destination, review and follow the
         * instructions in the <a href="https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html">Appendix - HTTP Endpoint
         * Delivery Request and Response Specifications.
         */
        var url: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration) : this() {
            this.accessKey = x.accessKey
            this.name = x.name
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.HttpEndpointConfiguration = HttpEndpointConfiguration(this)
    }
}
