// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.firehose.model



/**
 * The configuration of the HTTP endpoint request.
 */
class HttpEndpointRequestConfiguration private constructor(builder: Builder) {
    /**
     * Describes the metadata sent to the HTTP endpoint destination.
     */
    val commonAttributes: List<HttpEndpointCommonAttribute>? = builder.commonAttributes
    /**
     * Kinesis Data Firehose uses the content encoding to compress the body of a request before
     * sending the request to the destination. For more information, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding in MDN Web Docs, the official Mozilla documentation.
     */
    val contentEncoding: aws.sdk.kotlin.services.firehose.model.ContentEncoding? = builder.contentEncoding

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HttpEndpointRequestConfiguration(")
        append("commonAttributes=$commonAttributes,")
        append("contentEncoding=$contentEncoding)")
    }

    override fun hashCode(): kotlin.Int {
        var result = commonAttributes?.hashCode() ?: 0
        result = 31 * result + (contentEncoding?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HttpEndpointRequestConfiguration

        if (commonAttributes != other.commonAttributes) return false
        if (contentEncoding != other.contentEncoding) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Describes the metadata sent to the HTTP endpoint destination.
         */
        var commonAttributes: List<HttpEndpointCommonAttribute>? = null
        /**
         * Kinesis Data Firehose uses the content encoding to compress the body of a request before
         * sending the request to the destination. For more information, see <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding">Content-Encoding in MDN Web Docs, the official Mozilla documentation.
         */
        var contentEncoding: aws.sdk.kotlin.services.firehose.model.ContentEncoding? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration) : this() {
            this.commonAttributes = x.commonAttributes
            this.contentEncoding = x.contentEncoding
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.firehose.model.HttpEndpointRequestConfiguration = HttpEndpointRequestConfiguration(this)
    }
}
