// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.fis.model.*
import aws.sdk.kotlin.services.fis.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "fis"
public const val ServiceApiVersion: String = "2020-12-01"
public const val SdkVersion: String = "0.17.4-beta"

internal class DefaultFisClient(override val config: FisClient.Config) : FisClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates an experiment template.
     *
     * An experiment template includes the following components:
     * + **Targets**: A target can be a specific resource in your Amazon Web Services environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.
     * + **Actions**: The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.
     * + **Stop conditions**: If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.
     *
     * For more information, see [Experiment templates](https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html) in the *Fault Injection Simulator User Guide*.
     */
    override suspend fun createExperimentTemplate(input: CreateExperimentTemplateRequest): CreateExperimentTemplateResponse {
        val op = SdkHttpOperation.build<CreateExperimentTemplateRequest, CreateExperimentTemplateResponse> {
            serializer = CreateExperimentTemplateOperationSerializer()
            deserializer = CreateExperimentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateExperimentTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified experiment template.
     */
    override suspend fun deleteExperimentTemplate(input: DeleteExperimentTemplateRequest): DeleteExperimentTemplateResponse {
        val op = SdkHttpOperation.build<DeleteExperimentTemplateRequest, DeleteExperimentTemplateResponse> {
            serializer = DeleteExperimentTemplateOperationSerializer()
            deserializer = DeleteExperimentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteExperimentTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified FIS action.
     */
    override suspend fun getAction(input: GetActionRequest): GetActionResponse {
        val op = SdkHttpOperation.build<GetActionRequest, GetActionResponse> {
            serializer = GetActionOperationSerializer()
            deserializer = GetActionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAction"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified experiment.
     */
    override suspend fun getExperiment(input: GetExperimentRequest): GetExperimentResponse {
        val op = SdkHttpOperation.build<GetExperimentRequest, GetExperimentResponse> {
            serializer = GetExperimentOperationSerializer()
            deserializer = GetExperimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetExperiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified experiment template.
     */
    override suspend fun getExperimentTemplate(input: GetExperimentTemplateRequest): GetExperimentTemplateResponse {
        val op = SdkHttpOperation.build<GetExperimentTemplateRequest, GetExperimentTemplateResponse> {
            serializer = GetExperimentTemplateOperationSerializer()
            deserializer = GetExperimentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetExperimentTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified resource type.
     */
    override suspend fun getTargetResourceType(input: GetTargetResourceTypeRequest): GetTargetResourceTypeResponse {
        val op = SdkHttpOperation.build<GetTargetResourceTypeRequest, GetTargetResourceTypeResponse> {
            serializer = GetTargetResourceTypeOperationSerializer()
            deserializer = GetTargetResourceTypeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTargetResourceType"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the available FIS actions.
     */
    override suspend fun listActions(input: ListActionsRequest): ListActionsResponse {
        val op = SdkHttpOperation.build<ListActionsRequest, ListActionsResponse> {
            serializer = ListActionsOperationSerializer()
            deserializer = ListActionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListActions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your experiment templates.
     */
    override suspend fun listExperimentTemplates(input: ListExperimentTemplatesRequest): ListExperimentTemplatesResponse {
        val op = SdkHttpOperation.build<ListExperimentTemplatesRequest, ListExperimentTemplatesResponse> {
            serializer = ListExperimentTemplatesOperationSerializer()
            deserializer = ListExperimentTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListExperimentTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists your experiments.
     */
    override suspend fun listExperiments(input: ListExperimentsRequest): ListExperimentsResponse {
        val op = SdkHttpOperation.build<ListExperimentsRequest, ListExperimentsResponse> {
            serializer = ListExperimentsOperationSerializer()
            deserializer = ListExperimentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListExperiments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags for the specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the target resource types.
     */
    override suspend fun listTargetResourceTypes(input: ListTargetResourceTypesRequest): ListTargetResourceTypesResponse {
        val op = SdkHttpOperation.build<ListTargetResourceTypesRequest, ListTargetResourceTypesResponse> {
            serializer = ListTargetResourceTypesOperationSerializer()
            deserializer = ListTargetResourceTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTargetResourceTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts running an experiment from the specified experiment template.
     */
    override suspend fun startExperiment(input: StartExperimentRequest): StartExperimentResponse {
        val op = SdkHttpOperation.build<StartExperimentRequest, StartExperimentResponse> {
            serializer = StartExperimentOperationSerializer()
            deserializer = StartExperimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartExperiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops the specified experiment.
     */
    override suspend fun stopExperiment(input: StopExperimentRequest): StopExperimentResponse {
        val op = SdkHttpOperation.build<StopExperimentRequest, StopExperimentResponse> {
            serializer = StopExperimentOperationSerializer()
            deserializer = StopExperimentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopExperiment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Applies the specified tags to the specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified experiment template.
     */
    override suspend fun updateExperimentTemplate(input: UpdateExperimentTemplateRequest): UpdateExperimentTemplateResponse {
        val op = SdkHttpOperation.build<UpdateExperimentTemplateRequest, UpdateExperimentTemplateResponse> {
            serializer = UpdateExperimentTemplateOperationSerializer()
            deserializer = UpdateExperimentTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateExperimentTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fis"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "fis")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
