// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.fis.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.fis.model.*
import aws.sdk.kotlin.services.fis.model.CreateExperimentTemplateRequest
import aws.sdk.kotlin.services.fis.model.CreateExperimentTemplateResponse
import aws.sdk.kotlin.services.fis.model.DeleteExperimentTemplateRequest
import aws.sdk.kotlin.services.fis.model.DeleteExperimentTemplateResponse
import aws.sdk.kotlin.services.fis.model.GetActionRequest
import aws.sdk.kotlin.services.fis.model.GetActionResponse
import aws.sdk.kotlin.services.fis.model.GetExperimentRequest
import aws.sdk.kotlin.services.fis.model.GetExperimentResponse
import aws.sdk.kotlin.services.fis.model.GetExperimentTemplateRequest
import aws.sdk.kotlin.services.fis.model.GetExperimentTemplateResponse
import aws.sdk.kotlin.services.fis.model.GetTargetResourceTypeRequest
import aws.sdk.kotlin.services.fis.model.GetTargetResourceTypeResponse
import aws.sdk.kotlin.services.fis.model.ListActionsRequest
import aws.sdk.kotlin.services.fis.model.ListActionsResponse
import aws.sdk.kotlin.services.fis.model.ListExperimentTemplatesRequest
import aws.sdk.kotlin.services.fis.model.ListExperimentTemplatesResponse
import aws.sdk.kotlin.services.fis.model.ListExperimentsRequest
import aws.sdk.kotlin.services.fis.model.ListExperimentsResponse
import aws.sdk.kotlin.services.fis.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.fis.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.fis.model.ListTargetResourceTypesRequest
import aws.sdk.kotlin.services.fis.model.ListTargetResourceTypesResponse
import aws.sdk.kotlin.services.fis.model.StartExperimentRequest
import aws.sdk.kotlin.services.fis.model.StartExperimentResponse
import aws.sdk.kotlin.services.fis.model.StopExperimentRequest
import aws.sdk.kotlin.services.fis.model.StopExperimentResponse
import aws.sdk.kotlin.services.fis.model.TagResourceRequest
import aws.sdk.kotlin.services.fis.model.TagResourceResponse
import aws.sdk.kotlin.services.fis.model.UntagResourceRequest
import aws.sdk.kotlin.services.fis.model.UntagResourceResponse
import aws.sdk.kotlin.services.fis.model.UpdateExperimentTemplateRequest
import aws.sdk.kotlin.services.fis.model.UpdateExperimentTemplateResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Fault Injection Simulator is a managed service that enables you to perform fault injection experiments on your Amazon Web Services workloads. For more information, see the [Fault Injection Simulator User Guide](https://docs.aws.amazon.com/fis/latest/userguide/).
 */
public interface FisClient : SdkClient {

    override val serviceName: String
        get() = "fis"
    /**
     * FisClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): FisClient {
            val config = Config.Builder().apply(block).build()
            return DefaultFisClient(config)
        }

        public operator fun invoke(config: Config): FisClient = DefaultFisClient(config)

        /**
         * Construct a [FisClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): FisClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultFisClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an experiment template.
     *
     * An experiment template includes the following components:
     * + **Targets**: A target can be a specific resource in your Amazon Web Services environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.
     * + **Actions**: The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.
     * + **Stop conditions**: If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.
     *
     * For more information, see [Experiment templates](https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html) in the *Fault Injection Simulator User Guide*.
     */
    public suspend fun createExperimentTemplate(input: CreateExperimentTemplateRequest): CreateExperimentTemplateResponse

    /**
     * Deletes the specified experiment template.
     */
    public suspend fun deleteExperimentTemplate(input: DeleteExperimentTemplateRequest): DeleteExperimentTemplateResponse

    /**
     * Gets information about the specified FIS action.
     */
    public suspend fun getAction(input: GetActionRequest): GetActionResponse

    /**
     * Gets information about the specified experiment.
     */
    public suspend fun getExperiment(input: GetExperimentRequest): GetExperimentResponse

    /**
     * Gets information about the specified experiment template.
     */
    public suspend fun getExperimentTemplate(input: GetExperimentTemplateRequest): GetExperimentTemplateResponse

    /**
     * Gets information about the specified resource type.
     */
    public suspend fun getTargetResourceType(input: GetTargetResourceTypeRequest): GetTargetResourceTypeResponse

    /**
     * Lists the available FIS actions.
     */
    public suspend fun listActions(input: ListActionsRequest = ListActionsRequest {}): ListActionsResponse

    /**
     * Lists your experiment templates.
     */
    public suspend fun listExperimentTemplates(input: ListExperimentTemplatesRequest = ListExperimentTemplatesRequest {}): ListExperimentTemplatesResponse

    /**
     * Lists your experiments.
     */
    public suspend fun listExperiments(input: ListExperimentsRequest = ListExperimentsRequest {}): ListExperimentsResponse

    /**
     * Lists the tags for the specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the target resource types.
     */
    public suspend fun listTargetResourceTypes(input: ListTargetResourceTypesRequest = ListTargetResourceTypesRequest {}): ListTargetResourceTypesResponse

    /**
     * Starts running an experiment from the specified experiment template.
     */
    public suspend fun startExperiment(input: StartExperimentRequest): StartExperimentResponse

    /**
     * Stops the specified experiment.
     */
    public suspend fun stopExperiment(input: StopExperimentRequest): StopExperimentResponse

    /**
     * Applies the specified tags to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the specified experiment template.
     */
    public suspend fun updateExperimentTemplate(input: UpdateExperimentTemplateRequest): UpdateExperimentTemplateResponse
}

/**
 * Creates an experiment template.
 *
 * An experiment template includes the following components:
 * + **Targets**: A target can be a specific resource in your Amazon Web Services environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.
 * + **Actions**: The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.
 * + **Stop conditions**: If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.
 *
 * For more information, see [Experiment templates](https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html) in the *Fault Injection Simulator User Guide*.
 */
public suspend inline fun FisClient.createExperimentTemplate(crossinline block: CreateExperimentTemplateRequest.Builder.() -> Unit): CreateExperimentTemplateResponse = createExperimentTemplate(CreateExperimentTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the specified experiment template.
 */
public suspend inline fun FisClient.deleteExperimentTemplate(crossinline block: DeleteExperimentTemplateRequest.Builder.() -> Unit): DeleteExperimentTemplateResponse = deleteExperimentTemplate(DeleteExperimentTemplateRequest.Builder().apply(block).build())

/**
 * Gets information about the specified FIS action.
 */
public suspend inline fun FisClient.getAction(crossinline block: GetActionRequest.Builder.() -> Unit): GetActionResponse = getAction(GetActionRequest.Builder().apply(block).build())

/**
 * Gets information about the specified experiment.
 */
public suspend inline fun FisClient.getExperiment(crossinline block: GetExperimentRequest.Builder.() -> Unit): GetExperimentResponse = getExperiment(GetExperimentRequest.Builder().apply(block).build())

/**
 * Gets information about the specified experiment template.
 */
public suspend inline fun FisClient.getExperimentTemplate(crossinline block: GetExperimentTemplateRequest.Builder.() -> Unit): GetExperimentTemplateResponse = getExperimentTemplate(GetExperimentTemplateRequest.Builder().apply(block).build())

/**
 * Gets information about the specified resource type.
 */
public suspend inline fun FisClient.getTargetResourceType(crossinline block: GetTargetResourceTypeRequest.Builder.() -> Unit): GetTargetResourceTypeResponse = getTargetResourceType(GetTargetResourceTypeRequest.Builder().apply(block).build())

/**
 * Lists the available FIS actions.
 */
public suspend inline fun FisClient.listActions(crossinline block: ListActionsRequest.Builder.() -> Unit): ListActionsResponse = listActions(ListActionsRequest.Builder().apply(block).build())

/**
 * Lists your experiment templates.
 */
public suspend inline fun FisClient.listExperimentTemplates(crossinline block: ListExperimentTemplatesRequest.Builder.() -> Unit): ListExperimentTemplatesResponse = listExperimentTemplates(ListExperimentTemplatesRequest.Builder().apply(block).build())

/**
 * Lists your experiments.
 */
public suspend inline fun FisClient.listExperiments(crossinline block: ListExperimentsRequest.Builder.() -> Unit): ListExperimentsResponse = listExperiments(ListExperimentsRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 */
public suspend inline fun FisClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the target resource types.
 */
public suspend inline fun FisClient.listTargetResourceTypes(crossinline block: ListTargetResourceTypesRequest.Builder.() -> Unit): ListTargetResourceTypesResponse = listTargetResourceTypes(ListTargetResourceTypesRequest.Builder().apply(block).build())

/**
 * Starts running an experiment from the specified experiment template.
 */
public suspend inline fun FisClient.startExperiment(crossinline block: StartExperimentRequest.Builder.() -> Unit): StartExperimentResponse = startExperiment(StartExperimentRequest.Builder().apply(block).build())

/**
 * Stops the specified experiment.
 */
public suspend inline fun FisClient.stopExperiment(crossinline block: StopExperimentRequest.Builder.() -> Unit): StopExperimentResponse = stopExperiment(StopExperimentRequest.Builder().apply(block).build())

/**
 * Applies the specified tags to the specified resource.
 */
public suspend inline fun FisClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified resource.
 */
public suspend inline fun FisClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the specified experiment template.
 */
public suspend inline fun FisClient.updateExperimentTemplate(crossinline block: UpdateExperimentTemplateRequest.Builder.() -> Unit): UpdateExperimentTemplateResponse = updateExperimentTemplate(UpdateExperimentTemplateRequest.Builder().apply(block).build())
