// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis.paginators

import aws.sdk.kotlin.services.fis.FisClient
import aws.sdk.kotlin.services.fis.model.ListActionsRequest
import aws.sdk.kotlin.services.fis.model.ListActionsResponse
import aws.sdk.kotlin.services.fis.model.ListExperimentTemplatesRequest
import aws.sdk.kotlin.services.fis.model.ListExperimentTemplatesResponse
import aws.sdk.kotlin.services.fis.model.ListExperimentsRequest
import aws.sdk.kotlin.services.fis.model.ListExperimentsResponse
import aws.sdk.kotlin.services.fis.model.ListTargetResourceTypesRequest
import aws.sdk.kotlin.services.fis.model.ListTargetResourceTypesResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListActionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActionsResponse]
 */
public fun FisClient.listActionsPaginated(initialRequest: ListActionsRequest): Flow<ListActionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listActionsPaginated.listActions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListActionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListActionsResponse]
 */
public fun FisClient.listActionsPaginated(block: ListActionsRequest.Builder.() -> Unit): Flow<ListActionsResponse> =
    listActionsPaginated(ListActionsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListExperimentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExperimentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperimentsResponse]
 */
public fun FisClient.listExperimentsPaginated(initialRequest: ListExperimentsRequest): Flow<ListExperimentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExperimentsPaginated.listExperiments(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExperimentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperimentsResponse]
 */
public fun FisClient.listExperimentsPaginated(block: ListExperimentsRequest.Builder.() -> Unit): Flow<ListExperimentsResponse> =
    listExperimentsPaginated(ListExperimentsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListExperimentTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListExperimentTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperimentTemplatesResponse]
 */
public fun FisClient.listExperimentTemplatesPaginated(initialRequest: ListExperimentTemplatesRequest): Flow<ListExperimentTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listExperimentTemplatesPaginated.listExperimentTemplates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListExperimentTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListExperimentTemplatesResponse]
 */
public fun FisClient.listExperimentTemplatesPaginated(block: ListExperimentTemplatesRequest.Builder.() -> Unit): Flow<ListExperimentTemplatesResponse> =
    listExperimentTemplatesPaginated(ListExperimentTemplatesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListTargetResourceTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTargetResourceTypesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetResourceTypesResponse]
 */
public fun FisClient.listTargetResourceTypesPaginated(initialRequest: ListTargetResourceTypesRequest): Flow<ListTargetResourceTypesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTargetResourceTypesPaginated.listTargetResourceTypes(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListTargetResourceTypesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTargetResourceTypesResponse]
 */
public fun FisClient.listTargetResourceTypesPaginated(block: ListTargetResourceTypesRequest.Builder.() -> Unit): Flow<ListTargetResourceTypesResponse> =
    listTargetResourceTypesPaginated(ListTargetResourceTypesRequest.Builder().apply(block).build())
