// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis.transform

import aws.sdk.kotlin.services.fis.model.UpdateExperimentTemplateActionInputItem
import aws.sdk.kotlin.services.fis.model.UpdateExperimentTemplateLogConfigurationInput
import aws.sdk.kotlin.services.fis.model.UpdateExperimentTemplateRequest
import aws.sdk.kotlin.services.fis.model.UpdateExperimentTemplateStopConditionInput
import aws.sdk.kotlin.services.fis.model.UpdateExperimentTemplateTargetInput
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateExperimentTemplateOperationSerializer: HttpSerialize<UpdateExperimentTemplateRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateExperimentTemplateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            val pathSegments = listOf(
                "experimentTemplates",
                "${input.id}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateExperimentTemplateOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateExperimentTemplateOperationBody(context: ExecutionContext, input: UpdateExperimentTemplateRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("actions"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val LOGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("logConfiguration"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val STOPCONDITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("stopConditions"))
    val TARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("targets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIONS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(LOGCONFIGURATION_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(STOPCONDITIONS_DESCRIPTOR)
        field(TARGETS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.actions != null) {
            mapField(ACTIONS_DESCRIPTOR) {
                input.actions.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeUpdateExperimentTemplateActionInputItemDocument)) }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.logConfiguration?.let { field(LOGCONFIGURATION_DESCRIPTOR, it, ::serializeUpdateExperimentTemplateLogConfigurationInputDocument) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        if (input.stopConditions != null) {
            listField(STOPCONDITIONS_DESCRIPTOR) {
                for (el0 in input.stopConditions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeUpdateExperimentTemplateStopConditionInputDocument))
                }
            }
        }
        if (input.targets != null) {
            mapField(TARGETS_DESCRIPTOR) {
                input.targets.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeUpdateExperimentTemplateTargetInputDocument)) }
            }
        }
    }
    return serializer.toByteArray()
}
