// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis.model



/**
 * Specifies a target for an experiment. You must specify at least one Amazon Resource Name (ARN) or at least one resource tag. You cannot specify both ARNs and tags.
 *
 * For more information, see [Targets](https://docs.aws.amazon.com/fis/latest/userguide/targets.html) in the *Fault Injection Simulator User Guide*.
 */
public class CreateExperimentTemplateTargetInput private constructor(builder: Builder) {
    /**
     * The filters to apply to identify target resources using specific attributes.
     */
    public val filters: List<ExperimentTemplateTargetInputFilter>? = builder.filters
    /**
     * The resource type parameters.
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The Amazon Resource Names (ARNs) of the resources.
     */
    public val resourceArns: List<String>? = builder.resourceArns
    /**
     * The tags for the target resources.
     */
    public val resourceTags: Map<String, String>? = builder.resourceTags
    /**
     * The resource type. The resource type must be supported for the specified action.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. All identified resources are included in the target.
     * + ALL - Run the action on all identified targets. This is the default.
     * + COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random. For example, COUNT(1) selects one of the targets.
     * + PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets at random. For example, PERCENT(25) selects 25% of the targets.
     */
    public val selectionMode: kotlin.String? = builder.selectionMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fis.model.CreateExperimentTemplateTargetInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateExperimentTemplateTargetInput(")
        append("filters=$filters,")
        append("parameters=$parameters,")
        append("resourceArns=$resourceArns,")
        append("resourceTags=$resourceTags,")
        append("resourceType=$resourceType,")
        append("selectionMode=$selectionMode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (resourceArns?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (selectionMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateExperimentTemplateTargetInput

        if (filters != other.filters) return false
        if (parameters != other.parameters) return false
        if (resourceArns != other.resourceArns) return false
        if (resourceTags != other.resourceTags) return false
        if (resourceType != other.resourceType) return false
        if (selectionMode != other.selectionMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fis.model.CreateExperimentTemplateTargetInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The filters to apply to identify target resources using specific attributes.
         */
        public var filters: List<ExperimentTemplateTargetInputFilter>? = null
        /**
         * The resource type parameters.
         */
        public var parameters: Map<String, String>? = null
        /**
         * The Amazon Resource Names (ARNs) of the resources.
         */
        public var resourceArns: List<String>? = null
        /**
         * The tags for the target resources.
         */
        public var resourceTags: Map<String, String>? = null
        /**
         * The resource type. The resource type must be supported for the specified action.
         */
        public var resourceType: kotlin.String? = null
        /**
         * Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. All identified resources are included in the target.
         * + ALL - Run the action on all identified targets. This is the default.
         * + COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random. For example, COUNT(1) selects one of the targets.
         * + PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets at random. For example, PERCENT(25) selects 25% of the targets.
         */
        public var selectionMode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fis.model.CreateExperimentTemplateTargetInput) : this() {
            this.filters = x.filters
            this.parameters = x.parameters
            this.resourceArns = x.resourceArns
            this.resourceTags = x.resourceTags
            this.resourceType = x.resourceType
            this.selectionMode = x.selectionMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fis.model.CreateExperimentTemplateTargetInput = CreateExperimentTemplateTargetInput(this)
    }
}
