// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fis.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an experiment.
 */
public class Experiment private constructor(builder: Builder) {
    /**
     * The actions for the experiment.
     */
    public val actions: Map<String, ExperimentAction>? = builder.actions
    /**
     * The time that the experiment was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The time that the experiment ended.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The ID of the experiment template.
     */
    public val experimentTemplateId: kotlin.String? = builder.experimentTemplateId
    /**
     * The ID of the experiment.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The configuration for experiment logging.
     */
    public val logConfiguration: aws.sdk.kotlin.services.fis.model.ExperimentLogConfiguration? = builder.logConfiguration
    /**
     * The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The time that the experiment started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The state of the experiment.
     */
    public val state: aws.sdk.kotlin.services.fis.model.ExperimentState? = builder.state
    /**
     * The stop conditions for the experiment.
     */
    public val stopConditions: List<ExperimentStopCondition>? = builder.stopConditions
    /**
     * The tags for the experiment.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The targets for the experiment.
     */
    public val targets: Map<String, ExperimentTarget>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fis.model.Experiment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Experiment(")
        append("actions=$actions,")
        append("creationTime=$creationTime,")
        append("endTime=$endTime,")
        append("experimentTemplateId=$experimentTemplateId,")
        append("id=$id,")
        append("logConfiguration=$logConfiguration,")
        append("roleArn=$roleArn,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("stopConditions=$stopConditions,")
        append("tags=$tags,")
        append("targets=$targets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actions?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (experimentTemplateId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (logConfiguration?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stopConditions?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Experiment

        if (actions != other.actions) return false
        if (creationTime != other.creationTime) return false
        if (endTime != other.endTime) return false
        if (experimentTemplateId != other.experimentTemplateId) return false
        if (id != other.id) return false
        if (logConfiguration != other.logConfiguration) return false
        if (roleArn != other.roleArn) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (stopConditions != other.stopConditions) return false
        if (tags != other.tags) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fis.model.Experiment = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The actions for the experiment.
         */
        public var actions: Map<String, ExperimentAction>? = null
        /**
         * The time that the experiment was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the experiment ended.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the experiment template.
         */
        public var experimentTemplateId: kotlin.String? = null
        /**
         * The ID of the experiment.
         */
        public var id: kotlin.String? = null
        /**
         * The configuration for experiment logging.
         */
        public var logConfiguration: aws.sdk.kotlin.services.fis.model.ExperimentLogConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The time that the experiment started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The state of the experiment.
         */
        public var state: aws.sdk.kotlin.services.fis.model.ExperimentState? = null
        /**
         * The stop conditions for the experiment.
         */
        public var stopConditions: List<ExperimentStopCondition>? = null
        /**
         * The tags for the experiment.
         */
        public var tags: Map<String, String>? = null
        /**
         * The targets for the experiment.
         */
        public var targets: Map<String, ExperimentTarget>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fis.model.Experiment) : this() {
            this.actions = x.actions
            this.creationTime = x.creationTime
            this.endTime = x.endTime
            this.experimentTemplateId = x.experimentTemplateId
            this.id = x.id
            this.logConfiguration = x.logConfiguration
            this.roleArn = x.roleArn
            this.startTime = x.startTime
            this.state = x.state
            this.stopConditions = x.stopConditions
            this.tags = x.tags
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fis.model.Experiment = Experiment(this)

        /**
         * construct an [aws.sdk.kotlin.services.fis.model.ExperimentLogConfiguration] inside the given [block]
         */
        public fun logConfiguration(block: aws.sdk.kotlin.services.fis.model.ExperimentLogConfiguration.Builder.() -> kotlin.Unit) {
            this.logConfiguration = aws.sdk.kotlin.services.fis.model.ExperimentLogConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fis.model.ExperimentState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.fis.model.ExperimentState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.fis.model.ExperimentState.invoke(block)
        }
    }
}
