// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.fms.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.fms.model.*
import aws.sdk.kotlin.services.fms.model.AssociateAdminAccountRequest
import aws.sdk.kotlin.services.fms.model.AssociateAdminAccountResponse
import aws.sdk.kotlin.services.fms.model.AssociateThirdPartyFirewallRequest
import aws.sdk.kotlin.services.fms.model.AssociateThirdPartyFirewallResponse
import aws.sdk.kotlin.services.fms.model.BatchAssociateResourceRequest
import aws.sdk.kotlin.services.fms.model.BatchAssociateResourceResponse
import aws.sdk.kotlin.services.fms.model.BatchDisassociateResourceRequest
import aws.sdk.kotlin.services.fms.model.BatchDisassociateResourceResponse
import aws.sdk.kotlin.services.fms.model.DeleteAppsListRequest
import aws.sdk.kotlin.services.fms.model.DeleteAppsListResponse
import aws.sdk.kotlin.services.fms.model.DeleteNotificationChannelRequest
import aws.sdk.kotlin.services.fms.model.DeleteNotificationChannelResponse
import aws.sdk.kotlin.services.fms.model.DeletePolicyRequest
import aws.sdk.kotlin.services.fms.model.DeletePolicyResponse
import aws.sdk.kotlin.services.fms.model.DeleteProtocolsListRequest
import aws.sdk.kotlin.services.fms.model.DeleteProtocolsListResponse
import aws.sdk.kotlin.services.fms.model.DeleteResourceSetRequest
import aws.sdk.kotlin.services.fms.model.DeleteResourceSetResponse
import aws.sdk.kotlin.services.fms.model.DisassociateAdminAccountRequest
import aws.sdk.kotlin.services.fms.model.DisassociateAdminAccountResponse
import aws.sdk.kotlin.services.fms.model.DisassociateThirdPartyFirewallRequest
import aws.sdk.kotlin.services.fms.model.DisassociateThirdPartyFirewallResponse
import aws.sdk.kotlin.services.fms.model.GetAdminAccountRequest
import aws.sdk.kotlin.services.fms.model.GetAdminAccountResponse
import aws.sdk.kotlin.services.fms.model.GetAppsListRequest
import aws.sdk.kotlin.services.fms.model.GetAppsListResponse
import aws.sdk.kotlin.services.fms.model.GetComplianceDetailRequest
import aws.sdk.kotlin.services.fms.model.GetComplianceDetailResponse
import aws.sdk.kotlin.services.fms.model.GetNotificationChannelRequest
import aws.sdk.kotlin.services.fms.model.GetNotificationChannelResponse
import aws.sdk.kotlin.services.fms.model.GetPolicyRequest
import aws.sdk.kotlin.services.fms.model.GetPolicyResponse
import aws.sdk.kotlin.services.fms.model.GetProtectionStatusRequest
import aws.sdk.kotlin.services.fms.model.GetProtectionStatusResponse
import aws.sdk.kotlin.services.fms.model.GetProtocolsListRequest
import aws.sdk.kotlin.services.fms.model.GetProtocolsListResponse
import aws.sdk.kotlin.services.fms.model.GetResourceSetRequest
import aws.sdk.kotlin.services.fms.model.GetResourceSetResponse
import aws.sdk.kotlin.services.fms.model.GetThirdPartyFirewallAssociationStatusRequest
import aws.sdk.kotlin.services.fms.model.GetThirdPartyFirewallAssociationStatusResponse
import aws.sdk.kotlin.services.fms.model.GetViolationDetailsRequest
import aws.sdk.kotlin.services.fms.model.GetViolationDetailsResponse
import aws.sdk.kotlin.services.fms.model.ListAppsListsRequest
import aws.sdk.kotlin.services.fms.model.ListAppsListsResponse
import aws.sdk.kotlin.services.fms.model.ListComplianceStatusRequest
import aws.sdk.kotlin.services.fms.model.ListComplianceStatusResponse
import aws.sdk.kotlin.services.fms.model.ListDiscoveredResourcesRequest
import aws.sdk.kotlin.services.fms.model.ListDiscoveredResourcesResponse
import aws.sdk.kotlin.services.fms.model.ListMemberAccountsRequest
import aws.sdk.kotlin.services.fms.model.ListMemberAccountsResponse
import aws.sdk.kotlin.services.fms.model.ListPoliciesRequest
import aws.sdk.kotlin.services.fms.model.ListPoliciesResponse
import aws.sdk.kotlin.services.fms.model.ListProtocolsListsRequest
import aws.sdk.kotlin.services.fms.model.ListProtocolsListsResponse
import aws.sdk.kotlin.services.fms.model.ListResourceSetResourcesRequest
import aws.sdk.kotlin.services.fms.model.ListResourceSetResourcesResponse
import aws.sdk.kotlin.services.fms.model.ListResourceSetsRequest
import aws.sdk.kotlin.services.fms.model.ListResourceSetsResponse
import aws.sdk.kotlin.services.fms.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.fms.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest
import aws.sdk.kotlin.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse
import aws.sdk.kotlin.services.fms.model.PutAppsListRequest
import aws.sdk.kotlin.services.fms.model.PutAppsListResponse
import aws.sdk.kotlin.services.fms.model.PutNotificationChannelRequest
import aws.sdk.kotlin.services.fms.model.PutNotificationChannelResponse
import aws.sdk.kotlin.services.fms.model.PutPolicyRequest
import aws.sdk.kotlin.services.fms.model.PutPolicyResponse
import aws.sdk.kotlin.services.fms.model.PutProtocolsListRequest
import aws.sdk.kotlin.services.fms.model.PutProtocolsListResponse
import aws.sdk.kotlin.services.fms.model.PutResourceSetRequest
import aws.sdk.kotlin.services.fms.model.PutResourceSetResponse
import aws.sdk.kotlin.services.fms.model.TagResourceRequest
import aws.sdk.kotlin.services.fms.model.TagResourceResponse
import aws.sdk.kotlin.services.fms.model.UntagResourceRequest
import aws.sdk.kotlin.services.fms.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * This is the *Firewall Manager API Reference*. This guide is for developers who need detailed information about the Firewall Manager API actions, data types, and errors. For detailed information about Firewall Manager features, see the [Firewall Manager Developer Guide](https://docs.aws.amazon.com/waf/latest/developerguide/fms-chapter.html).
 *
 * Some API actions require explicit resource permissions. For information, see the developer guide topic [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html).
 */
public interface FmsClient : SdkClient {

    override val serviceName: String
        get() = "FMS"
    /**
     * FmsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): FmsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultFmsClient(config)
        }

        public operator fun invoke(config: Config): FmsClient = DefaultFmsClient(config)

        /**
         * Construct a [FmsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): FmsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultFmsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Sets the Firewall Manager administrator account. The account must be a member of the organization in Organizations whose resources you want to protect. Firewall Manager sets the permissions that allow the account to administer your Firewall Manager policies.
     *
     * The account that you associate with Firewall Manager is called the Firewall Manager administrator account.
     */
    public suspend fun associateAdminAccount(input: AssociateAdminAccountRequest): AssociateAdminAccountResponse

    /**
     * Sets the Firewall Manager policy administrator as a tenant administrator of a third-party firewall service. A tenant is an instance of the third-party firewall service that's associated with your Amazon Web Services customer account.
     */
    public suspend fun associateThirdPartyFirewall(input: AssociateThirdPartyFirewallRequest): AssociateThirdPartyFirewallResponse

    /**
     * Associate resources to a Firewall Manager resource set.
     */
    public suspend fun batchAssociateResource(input: BatchAssociateResourceRequest): BatchAssociateResourceResponse

    /**
     * Disassociates resources from a Firewall Manager resource set.
     */
    public suspend fun batchDisassociateResource(input: BatchDisassociateResourceRequest): BatchDisassociateResourceResponse

    /**
     * Permanently deletes an Firewall Manager applications list.
     */
    public suspend fun deleteAppsList(input: DeleteAppsListRequest): DeleteAppsListResponse

    /**
     * Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.
     */
    public suspend fun deleteNotificationChannel(input: DeleteNotificationChannelRequest = DeleteNotificationChannelRequest {}): DeleteNotificationChannelResponse

    /**
     * Permanently deletes an Firewall Manager policy.
     */
    public suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse

    /**
     * Permanently deletes an Firewall Manager protocols list.
     */
    public suspend fun deleteProtocolsList(input: DeleteProtocolsListRequest): DeleteProtocolsListResponse

    /**
     * Deletes the specified ResourceSet.
     */
    public suspend fun deleteResourceSet(input: DeleteResourceSetRequest): DeleteResourceSetResponse

    /**
     * Disassociates the account that has been set as the Firewall Manager administrator account. To set a different account as the administrator account, you must submit an `AssociateAdminAccount` request.
     */
    public suspend fun disassociateAdminAccount(input: DisassociateAdminAccountRequest = DisassociateAdminAccountRequest {}): DisassociateAdminAccountResponse

    /**
     * Disassociates a Firewall Manager policy administrator from a third-party firewall tenant. When you call `DisassociateThirdPartyFirewall`, the third-party firewall vendor deletes all of the firewalls that are associated with the account.
     */
    public suspend fun disassociateThirdPartyFirewall(input: DisassociateThirdPartyFirewallRequest): DisassociateThirdPartyFirewallResponse

    /**
     * Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager administrator.
     */
    public suspend fun getAdminAccount(input: GetAdminAccountRequest = GetAdminAccountRequest {}): GetAdminAccountResponse

    /**
     * Returns information about the specified Firewall Manager applications list.
     */
    public suspend fun getAppsList(input: GetAppsListRequest): GetAppsListResponse

    /**
     * Returns detailed compliance information about the specified member account. Details include resources that are in and out of compliance with the specified policy.
     * + Resources are considered noncompliant for WAF and Shield Advanced policies if the specified policy has not been applied to them.
     * + Resources are considered noncompliant for security group policies if they are in scope of the policy, they violate one or more of the policy rules, and remediation is disabled or not possible.
     * + Resources are considered noncompliant for Network Firewall policies if a firewall is missing in the VPC, if the firewall endpoint isn't set up in an expected Availability Zone and subnet, if a subnet created by the Firewall Manager doesn't have the expected route table, and for modifications to a firewall policy that violate the Firewall Manager policy's rules.
     * + Resources are considered noncompliant for DNS Firewall policies if a DNS Firewall rule group is missing from the rule group associations for the VPC.
     */
    public suspend fun getComplianceDetail(input: GetComplianceDetailRequest): GetComplianceDetailResponse

    /**
     * Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.
     */
    public suspend fun getNotificationChannel(input: GetNotificationChannelRequest = GetNotificationChannelRequest {}): GetNotificationChannelResponse

    /**
     * Returns information about the specified Firewall Manager policy.
     */
    public suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse

    /**
     * If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack. Other policy types are currently unsupported.
     */
    public suspend fun getProtectionStatus(input: GetProtectionStatusRequest): GetProtectionStatusResponse

    /**
     * Returns information about the specified Firewall Manager protocols list.
     */
    public suspend fun getProtocolsList(input: GetProtocolsListRequest): GetProtocolsListResponse

    /**
     * Gets information about a specific resource set.
     */
    public suspend fun getResourceSet(input: GetResourceSetRequest): GetResourceSetResponse

    /**
     * The onboarding status of a Firewall Manager admin account to third-party firewall vendor tenant.
     */
    public suspend fun getThirdPartyFirewallAssociationStatus(input: GetThirdPartyFirewallAssociationStatusRequest): GetThirdPartyFirewallAssociationStatusResponse

    /**
     * Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.
     */
    public suspend fun getViolationDetails(input: GetViolationDetailsRequest): GetViolationDetailsResponse

    /**
     * Returns an array of `AppsListDataSummary` objects.
     */
    public suspend fun listAppsLists(input: ListAppsListsRequest): ListAppsListsResponse

    /**
     * Returns an array of `PolicyComplianceStatus` objects. Use `PolicyComplianceStatus` to get a summary of which member accounts are protected by the specified policy.
     */
    public suspend fun listComplianceStatus(input: ListComplianceStatusRequest): ListComplianceStatusResponse

    /**
     * Returns an array of resources in the organization's accounts that are available to be associated with a resource set.
     */
    public suspend fun listDiscoveredResources(input: ListDiscoveredResourcesRequest): ListDiscoveredResourcesResponse

    /**
     * Returns a `MemberAccounts` object that lists the member accounts in the administrator's Amazon Web Services organization.
     *
     * The `ListMemberAccounts` must be submitted by the account that is set as the Firewall Manager administrator.
     */
    public suspend fun listMemberAccounts(input: ListMemberAccountsRequest = ListMemberAccountsRequest {}): ListMemberAccountsResponse

    /**
     * Returns an array of `PolicySummary` objects.
     */
    public suspend fun listPolicies(input: ListPoliciesRequest = ListPoliciesRequest {}): ListPoliciesResponse

    /**
     * Returns an array of `ProtocolsListDataSummary` objects.
     */
    public suspend fun listProtocolsLists(input: ListProtocolsListsRequest): ListProtocolsListsResponse

    /**
     * Returns an array of resources that are currently associated to a resource set.
     */
    public suspend fun listResourceSetResources(input: ListResourceSetResourcesRequest): ListResourceSetResourcesResponse

    /**
     * Returns an array of `ResourceSetSummary` objects.
     */
    public suspend fun listResourceSets(input: ListResourceSetsRequest = ListResourceSetsRequest {}): ListResourceSetsResponse

    /**
     * Retrieves the list of tags for the specified Amazon Web Services resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall administrator's account.
     */
    public suspend fun listThirdPartyFirewallFirewallPolicies(input: ListThirdPartyFirewallFirewallPoliciesRequest): ListThirdPartyFirewallFirewallPoliciesResponse

    /**
     * Creates an Firewall Manager applications list.
     */
    public suspend fun putAppsList(input: PutAppsListRequest): PutAppsListResponse

    /**
     * Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record SNS logs.
     *
     * To perform this action outside of the console, you must configure the SNS topic to allow the Firewall Manager role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *Firewall Manager Developer Guide*.
     */
    public suspend fun putNotificationChannel(input: PutNotificationChannelRequest): PutNotificationChannelResponse

    /**
     * Creates an Firewall Manager policy.
     *
     * Firewall Manager provides the following types of policies:
     * + An WAF policy (type WAFV2), which defines rule groups to run first in the corresponding WAF web ACL and rule groups to run last in the web ACL.
     * + An WAF Classic policy (type WAF), which defines a rule group.
     * + A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
     * + A security group policy, which manages VPC security groups across your Amazon Web Services organization.
     * + An Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
     * + A DNS Firewall policy, which provides Route 53 Resolver DNS Firewall rules to filter DNS queries for specified VPCs.
     *
     * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
     *
     * You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about subscribing to Shield Advanced, see [CreateSubscription](https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html).
     */
    public suspend fun putPolicy(input: PutPolicyRequest): PutPolicyResponse

    /**
     * Creates an Firewall Manager protocols list.
     */
    public suspend fun putProtocolsList(input: PutProtocolsListRequest): PutProtocolsListResponse

    /**
     * Creates the resource set.
     *
     * An Firewall Manager resource set defines the resources to import into an Firewall Manager policy from another Amazon Web Services service.
     */
    public suspend fun putResourceSet(input: PutResourceSetRequest): PutResourceSetResponse

    /**
     * Adds one or more tags to an Amazon Web Services resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from an Amazon Web Services resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Sets the Firewall Manager administrator account. The account must be a member of the organization in Organizations whose resources you want to protect. Firewall Manager sets the permissions that allow the account to administer your Firewall Manager policies.
 *
 * The account that you associate with Firewall Manager is called the Firewall Manager administrator account.
 */
public suspend inline fun FmsClient.associateAdminAccount(crossinline block: AssociateAdminAccountRequest.Builder.() -> Unit): AssociateAdminAccountResponse = associateAdminAccount(AssociateAdminAccountRequest.Builder().apply(block).build())

/**
 * Sets the Firewall Manager policy administrator as a tenant administrator of a third-party firewall service. A tenant is an instance of the third-party firewall service that's associated with your Amazon Web Services customer account.
 */
public suspend inline fun FmsClient.associateThirdPartyFirewall(crossinline block: AssociateThirdPartyFirewallRequest.Builder.() -> Unit): AssociateThirdPartyFirewallResponse = associateThirdPartyFirewall(AssociateThirdPartyFirewallRequest.Builder().apply(block).build())

/**
 * Associate resources to a Firewall Manager resource set.
 */
public suspend inline fun FmsClient.batchAssociateResource(crossinline block: BatchAssociateResourceRequest.Builder.() -> Unit): BatchAssociateResourceResponse = batchAssociateResource(BatchAssociateResourceRequest.Builder().apply(block).build())

/**
 * Disassociates resources from a Firewall Manager resource set.
 */
public suspend inline fun FmsClient.batchDisassociateResource(crossinline block: BatchDisassociateResourceRequest.Builder.() -> Unit): BatchDisassociateResourceResponse = batchDisassociateResource(BatchDisassociateResourceRequest.Builder().apply(block).build())

/**
 * Permanently deletes an Firewall Manager applications list.
 */
public suspend inline fun FmsClient.deleteAppsList(crossinline block: DeleteAppsListRequest.Builder.() -> Unit): DeleteAppsListResponse = deleteAppsList(DeleteAppsListRequest.Builder().apply(block).build())

/**
 * Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.
 */
public suspend inline fun FmsClient.deleteNotificationChannel(crossinline block: DeleteNotificationChannelRequest.Builder.() -> Unit): DeleteNotificationChannelResponse = deleteNotificationChannel(DeleteNotificationChannelRequest.Builder().apply(block).build())

/**
 * Permanently deletes an Firewall Manager policy.
 */
public suspend inline fun FmsClient.deletePolicy(crossinline block: DeletePolicyRequest.Builder.() -> Unit): DeletePolicyResponse = deletePolicy(DeletePolicyRequest.Builder().apply(block).build())

/**
 * Permanently deletes an Firewall Manager protocols list.
 */
public suspend inline fun FmsClient.deleteProtocolsList(crossinline block: DeleteProtocolsListRequest.Builder.() -> Unit): DeleteProtocolsListResponse = deleteProtocolsList(DeleteProtocolsListRequest.Builder().apply(block).build())

/**
 * Deletes the specified ResourceSet.
 */
public suspend inline fun FmsClient.deleteResourceSet(crossinline block: DeleteResourceSetRequest.Builder.() -> Unit): DeleteResourceSetResponse = deleteResourceSet(DeleteResourceSetRequest.Builder().apply(block).build())

/**
 * Disassociates the account that has been set as the Firewall Manager administrator account. To set a different account as the administrator account, you must submit an `AssociateAdminAccount` request.
 */
public suspend inline fun FmsClient.disassociateAdminAccount(crossinline block: DisassociateAdminAccountRequest.Builder.() -> Unit): DisassociateAdminAccountResponse = disassociateAdminAccount(DisassociateAdminAccountRequest.Builder().apply(block).build())

/**
 * Disassociates a Firewall Manager policy administrator from a third-party firewall tenant. When you call `DisassociateThirdPartyFirewall`, the third-party firewall vendor deletes all of the firewalls that are associated with the account.
 */
public suspend inline fun FmsClient.disassociateThirdPartyFirewall(crossinline block: DisassociateThirdPartyFirewallRequest.Builder.() -> Unit): DisassociateThirdPartyFirewallResponse = disassociateThirdPartyFirewall(DisassociateThirdPartyFirewallRequest.Builder().apply(block).build())

/**
 * Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager administrator.
 */
public suspend inline fun FmsClient.getAdminAccount(crossinline block: GetAdminAccountRequest.Builder.() -> Unit): GetAdminAccountResponse = getAdminAccount(GetAdminAccountRequest.Builder().apply(block).build())

/**
 * Returns information about the specified Firewall Manager applications list.
 */
public suspend inline fun FmsClient.getAppsList(crossinline block: GetAppsListRequest.Builder.() -> Unit): GetAppsListResponse = getAppsList(GetAppsListRequest.Builder().apply(block).build())

/**
 * Returns detailed compliance information about the specified member account. Details include resources that are in and out of compliance with the specified policy.
 * + Resources are considered noncompliant for WAF and Shield Advanced policies if the specified policy has not been applied to them.
 * + Resources are considered noncompliant for security group policies if they are in scope of the policy, they violate one or more of the policy rules, and remediation is disabled or not possible.
 * + Resources are considered noncompliant for Network Firewall policies if a firewall is missing in the VPC, if the firewall endpoint isn't set up in an expected Availability Zone and subnet, if a subnet created by the Firewall Manager doesn't have the expected route table, and for modifications to a firewall policy that violate the Firewall Manager policy's rules.
 * + Resources are considered noncompliant for DNS Firewall policies if a DNS Firewall rule group is missing from the rule group associations for the VPC.
 */
public suspend inline fun FmsClient.getComplianceDetail(crossinline block: GetComplianceDetailRequest.Builder.() -> Unit): GetComplianceDetailResponse = getComplianceDetail(GetComplianceDetailRequest.Builder().apply(block).build())

/**
 * Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.
 */
public suspend inline fun FmsClient.getNotificationChannel(crossinline block: GetNotificationChannelRequest.Builder.() -> Unit): GetNotificationChannelResponse = getNotificationChannel(GetNotificationChannelRequest.Builder().apply(block).build())

/**
 * Returns information about the specified Firewall Manager policy.
 */
public suspend inline fun FmsClient.getPolicy(crossinline block: GetPolicyRequest.Builder.() -> Unit): GetPolicyResponse = getPolicy(GetPolicyRequest.Builder().apply(block).build())

/**
 * If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack. Other policy types are currently unsupported.
 */
public suspend inline fun FmsClient.getProtectionStatus(crossinline block: GetProtectionStatusRequest.Builder.() -> Unit): GetProtectionStatusResponse = getProtectionStatus(GetProtectionStatusRequest.Builder().apply(block).build())

/**
 * Returns information about the specified Firewall Manager protocols list.
 */
public suspend inline fun FmsClient.getProtocolsList(crossinline block: GetProtocolsListRequest.Builder.() -> Unit): GetProtocolsListResponse = getProtocolsList(GetProtocolsListRequest.Builder().apply(block).build())

/**
 * Gets information about a specific resource set.
 */
public suspend inline fun FmsClient.getResourceSet(crossinline block: GetResourceSetRequest.Builder.() -> Unit): GetResourceSetResponse = getResourceSet(GetResourceSetRequest.Builder().apply(block).build())

/**
 * The onboarding status of a Firewall Manager admin account to third-party firewall vendor tenant.
 */
public suspend inline fun FmsClient.getThirdPartyFirewallAssociationStatus(crossinline block: GetThirdPartyFirewallAssociationStatusRequest.Builder.() -> Unit): GetThirdPartyFirewallAssociationStatusResponse = getThirdPartyFirewallAssociationStatus(GetThirdPartyFirewallAssociationStatusRequest.Builder().apply(block).build())

/**
 * Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.
 */
public suspend inline fun FmsClient.getViolationDetails(crossinline block: GetViolationDetailsRequest.Builder.() -> Unit): GetViolationDetailsResponse = getViolationDetails(GetViolationDetailsRequest.Builder().apply(block).build())

/**
 * Returns an array of `AppsListDataSummary` objects.
 */
public suspend inline fun FmsClient.listAppsLists(crossinline block: ListAppsListsRequest.Builder.() -> Unit): ListAppsListsResponse = listAppsLists(ListAppsListsRequest.Builder().apply(block).build())

/**
 * Returns an array of `PolicyComplianceStatus` objects. Use `PolicyComplianceStatus` to get a summary of which member accounts are protected by the specified policy.
 */
public suspend inline fun FmsClient.listComplianceStatus(crossinline block: ListComplianceStatusRequest.Builder.() -> Unit): ListComplianceStatusResponse = listComplianceStatus(ListComplianceStatusRequest.Builder().apply(block).build())

/**
 * Returns an array of resources in the organization's accounts that are available to be associated with a resource set.
 */
public suspend inline fun FmsClient.listDiscoveredResources(crossinline block: ListDiscoveredResourcesRequest.Builder.() -> Unit): ListDiscoveredResourcesResponse = listDiscoveredResources(ListDiscoveredResourcesRequest.Builder().apply(block).build())

/**
 * Returns a `MemberAccounts` object that lists the member accounts in the administrator's Amazon Web Services organization.
 *
 * The `ListMemberAccounts` must be submitted by the account that is set as the Firewall Manager administrator.
 */
public suspend inline fun FmsClient.listMemberAccounts(crossinline block: ListMemberAccountsRequest.Builder.() -> Unit): ListMemberAccountsResponse = listMemberAccounts(ListMemberAccountsRequest.Builder().apply(block).build())

/**
 * Returns an array of `PolicySummary` objects.
 */
public suspend inline fun FmsClient.listPolicies(crossinline block: ListPoliciesRequest.Builder.() -> Unit): ListPoliciesResponse = listPolicies(ListPoliciesRequest.Builder().apply(block).build())

/**
 * Returns an array of `ProtocolsListDataSummary` objects.
 */
public suspend inline fun FmsClient.listProtocolsLists(crossinline block: ListProtocolsListsRequest.Builder.() -> Unit): ListProtocolsListsResponse = listProtocolsLists(ListProtocolsListsRequest.Builder().apply(block).build())

/**
 * Returns an array of resources that are currently associated to a resource set.
 */
public suspend inline fun FmsClient.listResourceSetResources(crossinline block: ListResourceSetResourcesRequest.Builder.() -> Unit): ListResourceSetResourcesResponse = listResourceSetResources(ListResourceSetResourcesRequest.Builder().apply(block).build())

/**
 * Returns an array of `ResourceSetSummary` objects.
 */
public suspend inline fun FmsClient.listResourceSets(crossinline block: ListResourceSetsRequest.Builder.() -> Unit): ListResourceSetsResponse = listResourceSets(ListResourceSetsRequest.Builder().apply(block).build())

/**
 * Retrieves the list of tags for the specified Amazon Web Services resource.
 */
public suspend inline fun FmsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall administrator's account.
 */
public suspend inline fun FmsClient.listThirdPartyFirewallFirewallPolicies(crossinline block: ListThirdPartyFirewallFirewallPoliciesRequest.Builder.() -> Unit): ListThirdPartyFirewallFirewallPoliciesResponse = listThirdPartyFirewallFirewallPolicies(ListThirdPartyFirewallFirewallPoliciesRequest.Builder().apply(block).build())

/**
 * Creates an Firewall Manager applications list.
 */
public suspend inline fun FmsClient.putAppsList(crossinline block: PutAppsListRequest.Builder.() -> Unit): PutAppsListResponse = putAppsList(PutAppsListRequest.Builder().apply(block).build())

/**
 * Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record SNS logs.
 *
 * To perform this action outside of the console, you must configure the SNS topic to allow the Firewall Manager role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *Firewall Manager Developer Guide*.
 */
public suspend inline fun FmsClient.putNotificationChannel(crossinline block: PutNotificationChannelRequest.Builder.() -> Unit): PutNotificationChannelResponse = putNotificationChannel(PutNotificationChannelRequest.Builder().apply(block).build())

/**
 * Creates an Firewall Manager policy.
 *
 * Firewall Manager provides the following types of policies:
 * + An WAF policy (type WAFV2), which defines rule groups to run first in the corresponding WAF web ACL and rule groups to run last in the web ACL.
 * + An WAF Classic policy (type WAF), which defines a rule group.
 * + A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
 * + A security group policy, which manages VPC security groups across your Amazon Web Services organization.
 * + An Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
 * + A DNS Firewall policy, which provides Route 53 Resolver DNS Firewall rules to filter DNS queries for specified VPCs.
 *
 * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
 *
 * You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about subscribing to Shield Advanced, see [CreateSubscription](https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html).
 */
public suspend inline fun FmsClient.putPolicy(crossinline block: PutPolicyRequest.Builder.() -> Unit): PutPolicyResponse = putPolicy(PutPolicyRequest.Builder().apply(block).build())

/**
 * Creates an Firewall Manager protocols list.
 */
public suspend inline fun FmsClient.putProtocolsList(crossinline block: PutProtocolsListRequest.Builder.() -> Unit): PutProtocolsListResponse = putProtocolsList(PutProtocolsListRequest.Builder().apply(block).build())

/**
 * Creates the resource set.
 *
 * An Firewall Manager resource set defines the resources to import into an Firewall Manager policy from another Amazon Web Services service.
 */
public suspend inline fun FmsClient.putResourceSet(crossinline block: PutResourceSetRequest.Builder.() -> Unit): PutResourceSetResponse = putResourceSet(PutResourceSetRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to an Amazon Web Services resource.
 */
public suspend inline fun FmsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from an Amazon Web Services resource.
 */
public suspend inline fun FmsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
