// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * Details of the resource that is not protected by the policy.
 */
public class ComplianceViolator private constructor(builder: Builder) {
    /**
     * Metadata about the resource that doesn't comply with the policy scope.
     */
    public val metadata: Map<String, String>? = builder.metadata
    /**
     * The resource ID.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The resource type. This is in the format shown in the [Amazon Web Services Resource Types Reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html). For example: `AWS::ElasticLoadBalancingV2::LoadBalancer`, `AWS::CloudFront::Distribution`, or `AWS::NetworkFirewall::FirewallPolicy`.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The reason that the resource is not protected by the policy.
     */
    public val violationReason: aws.sdk.kotlin.services.fms.model.ViolationReason? = builder.violationReason

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.ComplianceViolator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComplianceViolator(")
        append("metadata=$metadata,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("violationReason=$violationReason)")
    }

    override fun hashCode(): kotlin.Int {
        var result = metadata?.hashCode() ?: 0
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (violationReason?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComplianceViolator

        if (metadata != other.metadata) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (violationReason != other.violationReason) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.ComplianceViolator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Metadata about the resource that doesn't comply with the policy scope.
         */
        public var metadata: Map<String, String>? = null
        /**
         * The resource ID.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The resource type. This is in the format shown in the [Amazon Web Services Resource Types Reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html). For example: `AWS::ElasticLoadBalancingV2::LoadBalancer`, `AWS::CloudFront::Distribution`, or `AWS::NetworkFirewall::FirewallPolicy`.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The reason that the resource is not protected by the policy.
         */
        public var violationReason: aws.sdk.kotlin.services.fms.model.ViolationReason? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.ComplianceViolator) : this() {
            this.metadata = x.metadata
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.violationReason = x.violationReason
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.ComplianceViolator = ComplianceViolator(this)
    }
}
