// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * A rule group that Firewall Manager tried to associate with a VPC has the same priority as a rule group that's already associated.
 */
public class DnsRuleGroupPriorityConflictViolation private constructor(builder: Builder) {
    /**
     * The ID of the Firewall Manager DNS Firewall policy that was already applied to the VPC. This policy contains the rule group that's already associated with the VPC.
     */
    public val conflictingPolicyId: kotlin.String? = builder.conflictingPolicyId
    /**
     * The priority setting of the two conflicting rule groups.
     */
    public val conflictingPriority: kotlin.Int = builder.conflictingPriority
    /**
     * The priorities of rule groups that are already associated with the VPC. To retry your operation, choose priority settings that aren't in this list for the rule groups in your new DNS Firewall policy.
     */
    public val unavailablePriorities: List<Int>? = builder.unavailablePriorities
    /**
     * Information about the VPC ID.
     */
    public val violationTarget: kotlin.String? = builder.violationTarget
    /**
     * A description of the violation that specifies the VPC and the rule group that's already associated with it.
     */
    public val violationTargetDescription: kotlin.String? = builder.violationTargetDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.DnsRuleGroupPriorityConflictViolation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DnsRuleGroupPriorityConflictViolation(")
        append("conflictingPolicyId=$conflictingPolicyId,")
        append("conflictingPriority=$conflictingPriority,")
        append("unavailablePriorities=$unavailablePriorities,")
        append("violationTarget=$violationTarget,")
        append("violationTargetDescription=$violationTargetDescription)")
    }

    override fun hashCode(): kotlin.Int {
        var result = conflictingPolicyId?.hashCode() ?: 0
        result = 31 * result + (conflictingPriority)
        result = 31 * result + (unavailablePriorities?.hashCode() ?: 0)
        result = 31 * result + (violationTarget?.hashCode() ?: 0)
        result = 31 * result + (violationTargetDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DnsRuleGroupPriorityConflictViolation

        if (conflictingPolicyId != other.conflictingPolicyId) return false
        if (conflictingPriority != other.conflictingPriority) return false
        if (unavailablePriorities != other.unavailablePriorities) return false
        if (violationTarget != other.violationTarget) return false
        if (violationTargetDescription != other.violationTargetDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.DnsRuleGroupPriorityConflictViolation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Firewall Manager DNS Firewall policy that was already applied to the VPC. This policy contains the rule group that's already associated with the VPC.
         */
        public var conflictingPolicyId: kotlin.String? = null
        /**
         * The priority setting of the two conflicting rule groups.
         */
        public var conflictingPriority: kotlin.Int = 0
        /**
         * The priorities of rule groups that are already associated with the VPC. To retry your operation, choose priority settings that aren't in this list for the rule groups in your new DNS Firewall policy.
         */
        public var unavailablePriorities: List<Int>? = null
        /**
         * Information about the VPC ID.
         */
        public var violationTarget: kotlin.String? = null
        /**
         * A description of the violation that specifies the VPC and the rule group that's already associated with it.
         */
        public var violationTargetDescription: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.DnsRuleGroupPriorityConflictViolation) : this() {
            this.conflictingPolicyId = x.conflictingPolicyId
            this.conflictingPriority = x.conflictingPriority
            this.unavailablePriorities = x.unavailablePriorities
            this.violationTarget = x.violationTarget
            this.violationTargetDescription = x.violationTargetDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.DnsRuleGroupPriorityConflictViolation = DnsRuleGroupPriorityConflictViolation(this)
    }
}
