// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * Describes the compliance status for the account. An account is considered noncompliant if it includes resources that are not protected by the specified policy or that don't comply with the policy.
 */
public class EvaluationResult private constructor(builder: Builder) {
    /**
     * Describes an Amazon Web Services account's compliance with the Firewall Manager policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.fms.model.PolicyComplianceStatusType? = builder.complianceStatus
    /**
     * Indicates that over 100 resources are noncompliant with the Firewall Manager policy.
     */
    public val evaluationLimitExceeded: kotlin.Boolean = builder.evaluationLimitExceeded
    /**
     * The number of resources that are noncompliant with the specified policy. For WAF and Shield Advanced policies, a resource is considered noncompliant if it is not associated with the policy. For security group policies, a resource is considered noncompliant if it doesn't comply with the rules of the policy and remediation is disabled or not possible.
     */
    public val violatorCount: kotlin.Long = builder.violatorCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.EvaluationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EvaluationResult(")
        append("complianceStatus=$complianceStatus,")
        append("evaluationLimitExceeded=$evaluationLimitExceeded,")
        append("violatorCount=$violatorCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = complianceStatus?.hashCode() ?: 0
        result = 31 * result + (evaluationLimitExceeded.hashCode())
        result = 31 * result + (violatorCount.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EvaluationResult

        if (complianceStatus != other.complianceStatus) return false
        if (evaluationLimitExceeded != other.evaluationLimitExceeded) return false
        if (violatorCount != other.violatorCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.EvaluationResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Describes an Amazon Web Services account's compliance with the Firewall Manager policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.fms.model.PolicyComplianceStatusType? = null
        /**
         * Indicates that over 100 resources are noncompliant with the Firewall Manager policy.
         */
        public var evaluationLimitExceeded: kotlin.Boolean = false
        /**
         * The number of resources that are noncompliant with the specified policy. For WAF and Shield Advanced policies, a resource is considered noncompliant if it is not associated with the policy. For security group policies, a resource is considered noncompliant if it doesn't comply with the rules of the policy and remediation is disabled or not possible.
         */
        public var violatorCount: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.EvaluationResult) : this() {
            this.complianceStatus = x.complianceStatus
            this.evaluationLimitExceeded = x.evaluationLimitExceeded
            this.violatorCount = x.violatorCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.EvaluationResult = EvaluationResult(this)
    }
}
