// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



public class ListDiscoveredResourcesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The Amazon Web Services account IDs to discover resources in. Only one account is supported per request. The account must be a member of your organization.
     */
    public val memberAccountIds: List<String>? = builder.memberAccountIds
    /**
     * When you request a list of objects with a `MaxResults` setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The type of resources to discover.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.ListDiscoveredResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDiscoveredResourcesRequest(")
        append("maxResults=$maxResults,")
        append("memberAccountIds=$memberAccountIds,")
        append("nextToken=$nextToken,")
        append("resourceType=$resourceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxResults ?: 0
        result = 31 * result + (memberAccountIds?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDiscoveredResourcesRequest

        if (maxResults != other.maxResults) return false
        if (memberAccountIds != other.memberAccountIds) return false
        if (nextToken != other.nextToken) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.ListDiscoveredResourcesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number of objects that you want Firewall Manager to return for this request. If more objects are available, in the response, Firewall Manager provides a `NextToken` value that you can use in a subsequent call to get the next batch of objects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The Amazon Web Services account IDs to discover resources in. Only one account is supported per request. The account must be a member of your organization.
         */
        public var memberAccountIds: List<String>? = null
        /**
         * When you request a list of objects with a `MaxResults` setting, if the number of objects that are still available for retrieval exceeds the maximum you requested, Firewall Manager returns a `NextToken` value in the response. To retrieve the next batch of objects, use the token returned from the prior request in your next request.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The type of resources to discover.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.ListDiscoveredResourcesRequest) : this() {
            this.maxResults = x.maxResults
            this.memberAccountIds = x.memberAccountIds
            this.nextToken = x.nextToken
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.ListDiscoveredResourcesRequest = ListDiscoveredResourcesRequest(this)
    }
}
