// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * Violation detail for the subnet for which internet traffic that hasn't been inspected.
 */
public class NetworkFirewallInternetTrafficNotInspectedViolation private constructor(builder: Builder) {
    /**
     * The actual firewall subnet routes.
     */
    public val actualFirewallSubnetRoutes: List<Route>? = builder.actualFirewallSubnetRoutes
    /**
     * The actual internet gateway routes.
     */
    public val actualInternetGatewayRoutes: List<Route>? = builder.actualInternetGatewayRoutes
    /**
     * Information about the subnet route table for the current firewall.
     */
    public val currentFirewallSubnetRouteTable: kotlin.String? = builder.currentFirewallSubnetRouteTable
    /**
     * The current route table for the internet gateway.
     */
    public val currentInternetGatewayRouteTable: kotlin.String? = builder.currentInternetGatewayRouteTable
    /**
     * The expected endpoint for the current firewall.
     */
    public val expectedFirewallEndpoint: kotlin.String? = builder.expectedFirewallEndpoint
    /**
     * The firewall subnet routes that are expected.
     */
    public val expectedFirewallSubnetRoutes: List<ExpectedRoute>? = builder.expectedFirewallSubnetRoutes
    /**
     * The internet gateway routes that are expected.
     */
    public val expectedInternetGatewayRoutes: List<ExpectedRoute>? = builder.expectedInternetGatewayRoutes
    /**
     * The firewall subnet ID.
     */
    public val firewallSubnetId: kotlin.String? = builder.firewallSubnetId
    /**
     * The internet gateway ID.
     */
    public val internetGatewayId: kotlin.String? = builder.internetGatewayId
    /**
     * Information about whether the route table is used in another Availability Zone.
     */
    public val isRouteTableUsedInDifferentAz: kotlin.Boolean = builder.isRouteTableUsedInDifferentAz
    /**
     * Information about the route table ID.
     */
    public val routeTableId: kotlin.String? = builder.routeTableId
    /**
     * The subnet Availability Zone.
     */
    public val subnetAvailabilityZone: kotlin.String? = builder.subnetAvailabilityZone
    /**
     * The subnet ID.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The route or routes that are in violation.
     */
    public val violatingRoutes: List<Route>? = builder.violatingRoutes
    /**
     * Information about the VPC ID.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkFirewallInternetTrafficNotInspectedViolation(")
        append("actualFirewallSubnetRoutes=$actualFirewallSubnetRoutes,")
        append("actualInternetGatewayRoutes=$actualInternetGatewayRoutes,")
        append("currentFirewallSubnetRouteTable=$currentFirewallSubnetRouteTable,")
        append("currentInternetGatewayRouteTable=$currentInternetGatewayRouteTable,")
        append("expectedFirewallEndpoint=$expectedFirewallEndpoint,")
        append("expectedFirewallSubnetRoutes=$expectedFirewallSubnetRoutes,")
        append("expectedInternetGatewayRoutes=$expectedInternetGatewayRoutes,")
        append("firewallSubnetId=$firewallSubnetId,")
        append("internetGatewayId=$internetGatewayId,")
        append("isRouteTableUsedInDifferentAz=$isRouteTableUsedInDifferentAz,")
        append("routeTableId=$routeTableId,")
        append("subnetAvailabilityZone=$subnetAvailabilityZone,")
        append("subnetId=$subnetId,")
        append("violatingRoutes=$violatingRoutes,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualFirewallSubnetRoutes?.hashCode() ?: 0
        result = 31 * result + (actualInternetGatewayRoutes?.hashCode() ?: 0)
        result = 31 * result + (currentFirewallSubnetRouteTable?.hashCode() ?: 0)
        result = 31 * result + (currentInternetGatewayRouteTable?.hashCode() ?: 0)
        result = 31 * result + (expectedFirewallEndpoint?.hashCode() ?: 0)
        result = 31 * result + (expectedFirewallSubnetRoutes?.hashCode() ?: 0)
        result = 31 * result + (expectedInternetGatewayRoutes?.hashCode() ?: 0)
        result = 31 * result + (firewallSubnetId?.hashCode() ?: 0)
        result = 31 * result + (internetGatewayId?.hashCode() ?: 0)
        result = 31 * result + (isRouteTableUsedInDifferentAz.hashCode())
        result = 31 * result + (routeTableId?.hashCode() ?: 0)
        result = 31 * result + (subnetAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (violatingRoutes?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkFirewallInternetTrafficNotInspectedViolation

        if (actualFirewallSubnetRoutes != other.actualFirewallSubnetRoutes) return false
        if (actualInternetGatewayRoutes != other.actualInternetGatewayRoutes) return false
        if (currentFirewallSubnetRouteTable != other.currentFirewallSubnetRouteTable) return false
        if (currentInternetGatewayRouteTable != other.currentInternetGatewayRouteTable) return false
        if (expectedFirewallEndpoint != other.expectedFirewallEndpoint) return false
        if (expectedFirewallSubnetRoutes != other.expectedFirewallSubnetRoutes) return false
        if (expectedInternetGatewayRoutes != other.expectedInternetGatewayRoutes) return false
        if (firewallSubnetId != other.firewallSubnetId) return false
        if (internetGatewayId != other.internetGatewayId) return false
        if (isRouteTableUsedInDifferentAz != other.isRouteTableUsedInDifferentAz) return false
        if (routeTableId != other.routeTableId) return false
        if (subnetAvailabilityZone != other.subnetAvailabilityZone) return false
        if (subnetId != other.subnetId) return false
        if (violatingRoutes != other.violatingRoutes) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The actual firewall subnet routes.
         */
        public var actualFirewallSubnetRoutes: List<Route>? = null
        /**
         * The actual internet gateway routes.
         */
        public var actualInternetGatewayRoutes: List<Route>? = null
        /**
         * Information about the subnet route table for the current firewall.
         */
        public var currentFirewallSubnetRouteTable: kotlin.String? = null
        /**
         * The current route table for the internet gateway.
         */
        public var currentInternetGatewayRouteTable: kotlin.String? = null
        /**
         * The expected endpoint for the current firewall.
         */
        public var expectedFirewallEndpoint: kotlin.String? = null
        /**
         * The firewall subnet routes that are expected.
         */
        public var expectedFirewallSubnetRoutes: List<ExpectedRoute>? = null
        /**
         * The internet gateway routes that are expected.
         */
        public var expectedInternetGatewayRoutes: List<ExpectedRoute>? = null
        /**
         * The firewall subnet ID.
         */
        public var firewallSubnetId: kotlin.String? = null
        /**
         * The internet gateway ID.
         */
        public var internetGatewayId: kotlin.String? = null
        /**
         * Information about whether the route table is used in another Availability Zone.
         */
        public var isRouteTableUsedInDifferentAz: kotlin.Boolean = false
        /**
         * Information about the route table ID.
         */
        public var routeTableId: kotlin.String? = null
        /**
         * The subnet Availability Zone.
         */
        public var subnetAvailabilityZone: kotlin.String? = null
        /**
         * The subnet ID.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The route or routes that are in violation.
         */
        public var violatingRoutes: List<Route>? = null
        /**
         * Information about the VPC ID.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation) : this() {
            this.actualFirewallSubnetRoutes = x.actualFirewallSubnetRoutes
            this.actualInternetGatewayRoutes = x.actualInternetGatewayRoutes
            this.currentFirewallSubnetRouteTable = x.currentFirewallSubnetRouteTable
            this.currentInternetGatewayRouteTable = x.currentInternetGatewayRouteTable
            this.expectedFirewallEndpoint = x.expectedFirewallEndpoint
            this.expectedFirewallSubnetRoutes = x.expectedFirewallSubnetRoutes
            this.expectedInternetGatewayRoutes = x.expectedInternetGatewayRoutes
            this.firewallSubnetId = x.firewallSubnetId
            this.internetGatewayId = x.internetGatewayId
            this.isRouteTableUsedInDifferentAz = x.isRouteTableUsedInDifferentAz
            this.routeTableId = x.routeTableId
            this.subnetAvailabilityZone = x.subnetAvailabilityZone
            this.subnetId = x.subnetId
            this.violatingRoutes = x.violatingRoutes
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.NetworkFirewallInternetTrafficNotInspectedViolation = NetworkFirewallInternetTrafficNotInspectedViolation(this)
    }
}
