// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * The definition of the Network Firewall firewall policy.
 */
public class NetworkFirewallPolicyDescription private constructor(builder: Builder) {
    /**
     * The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is optional, and is only valid when using the strict rule order.
     *
     *  Valid values of the stateful default action:
     * + aws:drop_strict
     * + aws:drop_established
     * + aws:alert_strict
     * + aws:alert_established
     */
    public val statefulDefaultActions: List<String>? = builder.statefulDefaultActions
    /**
     * Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
     */
    public val statefulEngineOptions: aws.sdk.kotlin.services.fms.model.StatefulEngineOptions? = builder.statefulEngineOptions
    /**
     * The stateful rule groups that are used in the Network Firewall firewall policy.
     */
    public val statefulRuleGroups: List<StatefulRuleGroup>? = builder.statefulRuleGroups
    /**
     * Names of custom actions that are available for use in the stateless default actions settings.
     */
    public val statelessCustomActions: List<String>? = builder.statelessCustomActions
    /**
     * The actions to take on packets that don't match any of the stateless rule groups.
     */
    public val statelessDefaultActions: List<String>? = builder.statelessDefaultActions
    /**
     * The actions to take on packet fragments that don't match any of the stateless rule groups.
     */
    public val statelessFragmentDefaultActions: List<String>? = builder.statelessFragmentDefaultActions
    /**
     * The stateless rule groups that are used in the Network Firewall firewall policy.
     */
    public val statelessRuleGroups: List<StatelessRuleGroup>? = builder.statelessRuleGroups

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.NetworkFirewallPolicyDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkFirewallPolicyDescription(")
        append("statefulDefaultActions=$statefulDefaultActions,")
        append("statefulEngineOptions=$statefulEngineOptions,")
        append("statefulRuleGroups=$statefulRuleGroups,")
        append("statelessCustomActions=$statelessCustomActions,")
        append("statelessDefaultActions=$statelessDefaultActions,")
        append("statelessFragmentDefaultActions=$statelessFragmentDefaultActions,")
        append("statelessRuleGroups=$statelessRuleGroups)")
    }

    override fun hashCode(): kotlin.Int {
        var result = statefulDefaultActions?.hashCode() ?: 0
        result = 31 * result + (statefulEngineOptions?.hashCode() ?: 0)
        result = 31 * result + (statefulRuleGroups?.hashCode() ?: 0)
        result = 31 * result + (statelessCustomActions?.hashCode() ?: 0)
        result = 31 * result + (statelessDefaultActions?.hashCode() ?: 0)
        result = 31 * result + (statelessFragmentDefaultActions?.hashCode() ?: 0)
        result = 31 * result + (statelessRuleGroups?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkFirewallPolicyDescription

        if (statefulDefaultActions != other.statefulDefaultActions) return false
        if (statefulEngineOptions != other.statefulEngineOptions) return false
        if (statefulRuleGroups != other.statefulRuleGroups) return false
        if (statelessCustomActions != other.statelessCustomActions) return false
        if (statelessDefaultActions != other.statelessDefaultActions) return false
        if (statelessFragmentDefaultActions != other.statelessFragmentDefaultActions) return false
        if (statelessRuleGroups != other.statelessRuleGroups) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.NetworkFirewallPolicyDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The default actions to take on a packet that doesn't match any stateful rules. The stateful default action is optional, and is only valid when using the strict rule order.
         *
         *  Valid values of the stateful default action:
         * + aws:drop_strict
         * + aws:drop_established
         * + aws:alert_strict
         * + aws:alert_established
         */
        public var statefulDefaultActions: List<String>? = null
        /**
         * Additional options governing how Network Firewall handles stateful rules. The stateful rule groups that you use in your policy must have stateful rule options settings that are compatible with these settings.
         */
        public var statefulEngineOptions: aws.sdk.kotlin.services.fms.model.StatefulEngineOptions? = null
        /**
         * The stateful rule groups that are used in the Network Firewall firewall policy.
         */
        public var statefulRuleGroups: List<StatefulRuleGroup>? = null
        /**
         * Names of custom actions that are available for use in the stateless default actions settings.
         */
        public var statelessCustomActions: List<String>? = null
        /**
         * The actions to take on packets that don't match any of the stateless rule groups.
         */
        public var statelessDefaultActions: List<String>? = null
        /**
         * The actions to take on packet fragments that don't match any of the stateless rule groups.
         */
        public var statelessFragmentDefaultActions: List<String>? = null
        /**
         * The stateless rule groups that are used in the Network Firewall firewall policy.
         */
        public var statelessRuleGroups: List<StatelessRuleGroup>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.NetworkFirewallPolicyDescription) : this() {
            this.statefulDefaultActions = x.statefulDefaultActions
            this.statefulEngineOptions = x.statefulEngineOptions
            this.statefulRuleGroups = x.statefulRuleGroups
            this.statelessCustomActions = x.statelessCustomActions
            this.statelessDefaultActions = x.statelessDefaultActions
            this.statelessFragmentDefaultActions = x.statelessFragmentDefaultActions
            this.statelessRuleGroups = x.statelessRuleGroups
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.NetworkFirewallPolicyDescription = NetworkFirewallPolicyDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.fms.model.StatefulEngineOptions] inside the given [block]
         */
        public fun statefulEngineOptions(block: aws.sdk.kotlin.services.fms.model.StatefulEngineOptions.Builder.() -> kotlin.Unit) {
            this.statefulEngineOptions = aws.sdk.kotlin.services.fms.model.StatefulEngineOptions.invoke(block)
        }
    }
}
