// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * An Firewall Manager policy.
 */
public class Policy private constructor(builder: Builder) {
    /**
     * Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
     *
     * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
     *
     * This option is not available for Shield Advanced or WAF Classic policies.
     */
    public val deleteUnusedFmManagedResources: kotlin.Boolean = builder.deleteUnusedFmManagedResources
    /**
     * Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to exclude from the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     *
     * You can specify inclusions or exclusions, but not both. If you specify an `IncludeMap`, Firewall Manager applies the policy to all accounts specified by the `IncludeMap`, and does not evaluate any `ExcludeMap` specifications. If you do not specify an `IncludeMap`, then Firewall Manager applies the policy to all accounts except for those specified by the `ExcludeMap`.
     *
     * You can specify account IDs, OUs, or a combination:
     * + Specify account IDs by setting the key to `ACCOUNT`. For example, the following is a valid map: `{“ACCOUNT” : [“accountID1”, “accountID2”]}`.
     * + Specify OUs by setting the key to `ORG_UNIT`. For example, the following is a valid map: `{“ORG_UNIT” : [“ouid111”, “ouid112”]}`.
     * + Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: `{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}`.
     */
    public val excludeMap: Map<String, List<String>>? = builder.excludeMap
    /**
     * If set to `True`, resources with the tags that are specified in the `ResourceTag` array are not in scope of the policy. If set to `False`, and the `ResourceTag` array is not null, only resources with the specified tags are in scope of the policy.
     */
    public val excludeResourceTags: kotlin.Boolean = builder.excludeResourceTags
    /**
     * Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to include in the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
     *
     * You can specify inclusions or exclusions, but not both. If you specify an `IncludeMap`, Firewall Manager applies the policy to all accounts specified by the `IncludeMap`, and does not evaluate any `ExcludeMap` specifications. If you do not specify an `IncludeMap`, then Firewall Manager applies the policy to all accounts except for those specified by the `ExcludeMap`.
     *
     * You can specify account IDs, OUs, or a combination:
     * + Specify account IDs by setting the key to `ACCOUNT`. For example, the following is a valid map: `{“ACCOUNT” : [“accountID1”, “accountID2”]}`.
     * + Specify OUs by setting the key to `ORG_UNIT`. For example, the following is a valid map: `{“ORG_UNIT” : [“ouid111”, “ouid112”]}`.
     * + Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: `{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}`.
     */
    public val includeMap: Map<String, List<String>>? = builder.includeMap
    /**
     * The definition of the Network Firewall firewall policy.
     */
    public val policyDescription: kotlin.String? = builder.policyDescription
    /**
     * The ID of the Firewall Manager policy.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The name of the Firewall Manager policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * A unique identifier for each update to the policy. When issuing a `PutPolicy` request, the `PolicyUpdateToken` in the request must match the `PolicyUpdateToken` of the current policy version. To get the `PolicyUpdateToken` of the current policy version, use a `GetPolicy` request.
     */
    public val policyUpdateToken: kotlin.String? = builder.policyUpdateToken
    /**
     * Indicates if the policy should be automatically applied to new resources.
     */
    public val remediationEnabled: kotlin.Boolean = builder.remediationEnabled
    /**
     * The unique identifiers of the resource sets used by the policy.
     */
    public val resourceSetIds: List<String>? = builder.resourceSetIds
    /**
     * An array of `ResourceTag` objects.
     */
    public val resourceTags: List<ResourceTag>? = builder.resourceTags
    /**
     * The type of resource protected by or in scope of the policy. This is in the format shown in the [Amazon Web Services Resource Types Reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html). To apply this policy to multiple resource types, specify a resource type of `ResourceTypeList` and then specify the resource types in a `ResourceTypeList`.
     *
     * For WAF and Shield Advanced, resource types include `AWS::ElasticLoadBalancingV2::LoadBalancer`, `AWS::ElasticLoadBalancing::LoadBalancer`, `AWS::EC2::EIP`, and `AWS::CloudFront::Distribution`. For a security group common policy, valid values are `AWS::EC2::NetworkInterface` and `AWS::EC2::Instance`. For a security group content audit policy, valid values are `AWS::EC2::SecurityGroup`, `AWS::EC2::NetworkInterface`, and `AWS::EC2::Instance`. For a security group usage audit policy, the value is `AWS::EC2::SecurityGroup`. For an Network Firewall policy or DNS Firewall policy, the value is `AWS::EC2::VPC`.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * An array of `ResourceType` objects. Use this only to specify multiple resource types. To specify a single resource type, use `ResourceType`.
     */
    public val resourceTypeList: List<String>? = builder.resourceTypeList
    /**
     * Details about the security service that is being used to protect the resources.
     */
    public val securityServicePolicyData: aws.sdk.kotlin.services.fms.model.SecurityServicePolicyData? = builder.securityServicePolicyData

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.Policy = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Policy(")
        append("deleteUnusedFmManagedResources=$deleteUnusedFmManagedResources,")
        append("excludeMap=$excludeMap,")
        append("excludeResourceTags=$excludeResourceTags,")
        append("includeMap=$includeMap,")
        append("policyDescription=$policyDescription,")
        append("policyId=$policyId,")
        append("policyName=$policyName,")
        append("policyUpdateToken=$policyUpdateToken,")
        append("remediationEnabled=$remediationEnabled,")
        append("resourceSetIds=$resourceSetIds,")
        append("resourceTags=$resourceTags,")
        append("resourceType=$resourceType,")
        append("resourceTypeList=$resourceTypeList,")
        append("securityServicePolicyData=$securityServicePolicyData)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteUnusedFmManagedResources.hashCode()
        result = 31 * result + (excludeMap?.hashCode() ?: 0)
        result = 31 * result + (excludeResourceTags.hashCode())
        result = 31 * result + (includeMap?.hashCode() ?: 0)
        result = 31 * result + (policyDescription?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (policyUpdateToken?.hashCode() ?: 0)
        result = 31 * result + (remediationEnabled.hashCode())
        result = 31 * result + (resourceSetIds?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (resourceTypeList?.hashCode() ?: 0)
        result = 31 * result + (securityServicePolicyData?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Policy

        if (deleteUnusedFmManagedResources != other.deleteUnusedFmManagedResources) return false
        if (excludeMap != other.excludeMap) return false
        if (excludeResourceTags != other.excludeResourceTags) return false
        if (includeMap != other.includeMap) return false
        if (policyDescription != other.policyDescription) return false
        if (policyId != other.policyId) return false
        if (policyName != other.policyName) return false
        if (policyUpdateToken != other.policyUpdateToken) return false
        if (remediationEnabled != other.remediationEnabled) return false
        if (resourceSetIds != other.resourceSetIds) return false
        if (resourceTags != other.resourceTags) return false
        if (resourceType != other.resourceType) return false
        if (resourceTypeList != other.resourceTypeList) return false
        if (securityServicePolicyData != other.securityServicePolicyData) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.Policy = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
         *
         * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
         *
         * This option is not available for Shield Advanced or WAF Classic policies.
         */
        public var deleteUnusedFmManagedResources: kotlin.Boolean = false
        /**
         * Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to exclude from the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         *
         * You can specify inclusions or exclusions, but not both. If you specify an `IncludeMap`, Firewall Manager applies the policy to all accounts specified by the `IncludeMap`, and does not evaluate any `ExcludeMap` specifications. If you do not specify an `IncludeMap`, then Firewall Manager applies the policy to all accounts except for those specified by the `ExcludeMap`.
         *
         * You can specify account IDs, OUs, or a combination:
         * + Specify account IDs by setting the key to `ACCOUNT`. For example, the following is a valid map: `{“ACCOUNT” : [“accountID1”, “accountID2”]}`.
         * + Specify OUs by setting the key to `ORG_UNIT`. For example, the following is a valid map: `{“ORG_UNIT” : [“ouid111”, “ouid112”]}`.
         * + Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: `{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}`.
         */
        public var excludeMap: Map<String, List<String>>? = null
        /**
         * If set to `True`, resources with the tags that are specified in the `ResourceTag` array are not in scope of the policy. If set to `False`, and the `ResourceTag` array is not null, only resources with the specified tags are in scope of the policy.
         */
        public var excludeResourceTags: kotlin.Boolean = false
        /**
         * Specifies the Amazon Web Services account IDs and Organizations organizational units (OUs) to include in the policy. Specifying an OU is the equivalent of specifying all accounts in the OU and in any of its child OUs, including any child OUs and accounts that are added at a later time.
         *
         * You can specify inclusions or exclusions, but not both. If you specify an `IncludeMap`, Firewall Manager applies the policy to all accounts specified by the `IncludeMap`, and does not evaluate any `ExcludeMap` specifications. If you do not specify an `IncludeMap`, then Firewall Manager applies the policy to all accounts except for those specified by the `ExcludeMap`.
         *
         * You can specify account IDs, OUs, or a combination:
         * + Specify account IDs by setting the key to `ACCOUNT`. For example, the following is a valid map: `{“ACCOUNT” : [“accountID1”, “accountID2”]}`.
         * + Specify OUs by setting the key to `ORG_UNIT`. For example, the following is a valid map: `{“ORG_UNIT” : [“ouid111”, “ouid112”]}`.
         * + Specify accounts and OUs together in a single map, separated with a comma. For example, the following is a valid map: `{“ACCOUNT” : [“accountID1”, “accountID2”], “ORG_UNIT” : [“ouid111”, “ouid112”]}`.
         */
        public var includeMap: Map<String, List<String>>? = null
        /**
         * The definition of the Network Firewall firewall policy.
         */
        public var policyDescription: kotlin.String? = null
        /**
         * The ID of the Firewall Manager policy.
         */
        public var policyId: kotlin.String? = null
        /**
         * The name of the Firewall Manager policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * A unique identifier for each update to the policy. When issuing a `PutPolicy` request, the `PolicyUpdateToken` in the request must match the `PolicyUpdateToken` of the current policy version. To get the `PolicyUpdateToken` of the current policy version, use a `GetPolicy` request.
         */
        public var policyUpdateToken: kotlin.String? = null
        /**
         * Indicates if the policy should be automatically applied to new resources.
         */
        public var remediationEnabled: kotlin.Boolean = false
        /**
         * The unique identifiers of the resource sets used by the policy.
         */
        public var resourceSetIds: List<String>? = null
        /**
         * An array of `ResourceTag` objects.
         */
        public var resourceTags: List<ResourceTag>? = null
        /**
         * The type of resource protected by or in scope of the policy. This is in the format shown in the [Amazon Web Services Resource Types Reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html). To apply this policy to multiple resource types, specify a resource type of `ResourceTypeList` and then specify the resource types in a `ResourceTypeList`.
         *
         * For WAF and Shield Advanced, resource types include `AWS::ElasticLoadBalancingV2::LoadBalancer`, `AWS::ElasticLoadBalancing::LoadBalancer`, `AWS::EC2::EIP`, and `AWS::CloudFront::Distribution`. For a security group common policy, valid values are `AWS::EC2::NetworkInterface` and `AWS::EC2::Instance`. For a security group content audit policy, valid values are `AWS::EC2::SecurityGroup`, `AWS::EC2::NetworkInterface`, and `AWS::EC2::Instance`. For a security group usage audit policy, the value is `AWS::EC2::SecurityGroup`. For an Network Firewall policy or DNS Firewall policy, the value is `AWS::EC2::VPC`.
         */
        public var resourceType: kotlin.String? = null
        /**
         * An array of `ResourceType` objects. Use this only to specify multiple resource types. To specify a single resource type, use `ResourceType`.
         */
        public var resourceTypeList: List<String>? = null
        /**
         * Details about the security service that is being used to protect the resources.
         */
        public var securityServicePolicyData: aws.sdk.kotlin.services.fms.model.SecurityServicePolicyData? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.Policy) : this() {
            this.deleteUnusedFmManagedResources = x.deleteUnusedFmManagedResources
            this.excludeMap = x.excludeMap
            this.excludeResourceTags = x.excludeResourceTags
            this.includeMap = x.includeMap
            this.policyDescription = x.policyDescription
            this.policyId = x.policyId
            this.policyName = x.policyName
            this.policyUpdateToken = x.policyUpdateToken
            this.remediationEnabled = x.remediationEnabled
            this.resourceSetIds = x.resourceSetIds
            this.resourceTags = x.resourceTags
            this.resourceType = x.resourceType
            this.resourceTypeList = x.resourceTypeList
            this.securityServicePolicyData = x.securityServicePolicyData
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.Policy = Policy(this)

        /**
         * construct an [aws.sdk.kotlin.services.fms.model.SecurityServicePolicyData] inside the given [block]
         */
        public fun securityServicePolicyData(block: aws.sdk.kotlin.services.fms.model.SecurityServicePolicyData.Builder.() -> kotlin.Unit) {
            this.securityServicePolicyData = aws.sdk.kotlin.services.fms.model.SecurityServicePolicyData.invoke(block)
        }
    }
}
