// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A set of resources to include in a policy.
 */
public class ResourceSet private constructor(builder: Builder) {
    /**
     * A description of the resource set.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier for the resource set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The last time that the resource set was changed.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The descriptive name of the resource set. You can't change the name of a resource set after you create it.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
     */
    public val resourceTypeList: List<String>? = builder.resourceTypeList
    /**
     * An optional token that you can use for optimistic locking. Firewall Manager returns a token to your requests that access the resource set. The token marks the state of the resource set resource at the time of the request. Update tokens are not allowed when creating a resource set. After creation, each subsequent update call to the resource set requires the update token.
     *
     * To make an unconditional change to the resource set, omit the token in your update request. Without the token, Firewall Manager performs your updates regardless of whether the resource set has changed since you last retrieved it.
     *
     * To make a conditional change to the resource set, provide the token in your update request. Firewall Manager uses the token to ensure that the resource set hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the resource set again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token.
     */
    public val updateToken: kotlin.String? = builder.updateToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.ResourceSet = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceSet(")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("name=$name,")
        append("resourceTypeList=$resourceTypeList,")
        append("updateToken=$updateToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceTypeList?.hashCode() ?: 0)
        result = 31 * result + (updateToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceSet

        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (name != other.name) return false
        if (resourceTypeList != other.resourceTypeList) return false
        if (updateToken != other.updateToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.ResourceSet = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the resource set.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier for the resource set. This ID is returned in the responses to create and list commands. You provide it to operations like update and delete.
         */
        public var id: kotlin.String? = null
        /**
         * The last time that the resource set was changed.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The descriptive name of the resource set. You can't change the name of a resource set after you create it.
         */
        public var name: kotlin.String? = null
        /**
         * Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
         */
        public var resourceTypeList: List<String>? = null
        /**
         * An optional token that you can use for optimistic locking. Firewall Manager returns a token to your requests that access the resource set. The token marks the state of the resource set resource at the time of the request. Update tokens are not allowed when creating a resource set. After creation, each subsequent update call to the resource set requires the update token.
         *
         * To make an unconditional change to the resource set, omit the token in your update request. Without the token, Firewall Manager performs your updates regardless of whether the resource set has changed since you last retrieved it.
         *
         * To make a conditional change to the resource set, provide the token in your update request. Firewall Manager uses the token to ensure that the resource set hasn't changed since you last retrieved it. If it has changed, the operation fails with an `InvalidTokenException`. If this happens, retrieve the resource set again to get a current copy of it with a new token. Reapply your changes as needed, then try the operation again using the new token.
         */
        public var updateToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.ResourceSet) : this() {
            this.description = x.description
            this.id = x.id
            this.lastUpdateTime = x.lastUpdateTime
            this.name = x.name
            this.resourceTypeList = x.resourceTypeList
            this.updateToken = x.updateToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.ResourceSet = ResourceSet(this)
    }
}
