// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * Describes a set of permissions for a security group rule.
 */
public class SecurityGroupRuleDescription private constructor(builder: Builder) {
    /**
     * The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of `-1` indicates all ICMP/ICMPv6 types.
     */
    public val fromPort: kotlin.Long? = builder.fromPort
    /**
     * The IPv4 ranges for the security group rule.
     */
    public val ipv4Range: kotlin.String? = builder.ipv4Range
    /**
     * The IPv6 ranges for the security group rule.
     */
    public val ipv6Range: kotlin.String? = builder.ipv6Range
    /**
     * The ID of the prefix list for the security group rule.
     */
    public val prefixListId: kotlin.String? = builder.prefixListId
    /**
     * The IP protocol name (`tcp`, `udp`, `icmp`, `icmpv6`) or number.
     */
    public val protocol: kotlin.String? = builder.protocol
    /**
     * The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of `-1` indicates all ICMP/ICMPv6 codes.
     */
    public val toPort: kotlin.Long? = builder.toPort

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.SecurityGroupRuleDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityGroupRuleDescription(")
        append("fromPort=$fromPort,")
        append("ipv4Range=$ipv4Range,")
        append("ipv6Range=$ipv6Range,")
        append("prefixListId=$prefixListId,")
        append("protocol=$protocol,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fromPort?.hashCode() ?: 0
        result = 31 * result + (ipv4Range?.hashCode() ?: 0)
        result = 31 * result + (ipv6Range?.hashCode() ?: 0)
        result = 31 * result + (prefixListId?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (toPort?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityGroupRuleDescription

        if (fromPort != other.fromPort) return false
        if (ipv4Range != other.ipv4Range) return false
        if (ipv6Range != other.ipv6Range) return false
        if (prefixListId != other.prefixListId) return false
        if (protocol != other.protocol) return false
        if (toPort != other.toPort) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.SecurityGroupRuleDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The start of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type number. A value of `-1` indicates all ICMP/ICMPv6 types.
         */
        public var fromPort: kotlin.Long? = null
        /**
         * The IPv4 ranges for the security group rule.
         */
        public var ipv4Range: kotlin.String? = null
        /**
         * The IPv6 ranges for the security group rule.
         */
        public var ipv6Range: kotlin.String? = null
        /**
         * The ID of the prefix list for the security group rule.
         */
        public var prefixListId: kotlin.String? = null
        /**
         * The IP protocol name (`tcp`, `udp`, `icmp`, `icmpv6`) or number.
         */
        public var protocol: kotlin.String? = null
        /**
         * The end of the port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of `-1` indicates all ICMP/ICMPv6 codes.
         */
        public var toPort: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.SecurityGroupRuleDescription) : this() {
            this.fromPort = x.fromPort
            this.ipv4Range = x.ipv4Range
            this.ipv6Range = x.ipv6Range
            this.prefixListId = x.prefixListId
            this.protocol = x.protocol
            this.toPort = x.toPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.SecurityGroupRuleDescription = SecurityGroupRuleDescription(this)
    }
}
