// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.paginators

import aws.sdk.kotlin.services.fms.FmsClient
import aws.sdk.kotlin.services.fms.model.AppsListDataSummary
import aws.sdk.kotlin.services.fms.model.ListAppsListsRequest
import aws.sdk.kotlin.services.fms.model.ListAppsListsResponse
import aws.sdk.kotlin.services.fms.model.ListComplianceStatusRequest
import aws.sdk.kotlin.services.fms.model.ListComplianceStatusResponse
import aws.sdk.kotlin.services.fms.model.ListMemberAccountsRequest
import aws.sdk.kotlin.services.fms.model.ListMemberAccountsResponse
import aws.sdk.kotlin.services.fms.model.ListPoliciesRequest
import aws.sdk.kotlin.services.fms.model.ListPoliciesResponse
import aws.sdk.kotlin.services.fms.model.ListProtocolsListsRequest
import aws.sdk.kotlin.services.fms.model.ListProtocolsListsResponse
import aws.sdk.kotlin.services.fms.model.ListThirdPartyFirewallFirewallPoliciesRequest
import aws.sdk.kotlin.services.fms.model.ListThirdPartyFirewallFirewallPoliciesResponse
import aws.sdk.kotlin.services.fms.model.PolicyComplianceStatus
import aws.sdk.kotlin.services.fms.model.PolicySummary
import aws.sdk.kotlin.services.fms.model.ProtocolsListDataSummary
import aws.sdk.kotlin.services.fms.model.ThirdPartyFirewallFirewallPolicy
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAppsListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppsListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppsListsResponse]
 */
public fun FmsClient.listAppsListsPaginated(initialRequest: ListAppsListsRequest): Flow<ListAppsListsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppsListsPaginated.listAppsLists(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAppsListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppsListsResponse]
 */
public fun FmsClient.listAppsListsPaginated(block: ListAppsListsRequest.Builder.() -> Unit): Flow<ListAppsListsResponse> =
    listAppsListsPaginated(ListAppsListsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAppsListsPaginated]
 * to access the nested member [AppsListDataSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AppsListDataSummary]
 */
@JvmName("listAppsListsResponseAppsListDataSummary")
public fun Flow<ListAppsListsResponse>.appsLists(): Flow<AppsListDataSummary> =
    transform() { response ->
        response.appsLists?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListComplianceStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListComplianceStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComplianceStatusResponse]
 */
public fun FmsClient.listComplianceStatusPaginated(initialRequest: ListComplianceStatusRequest): Flow<ListComplianceStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listComplianceStatusPaginated.listComplianceStatus(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListComplianceStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListComplianceStatusResponse]
 */
public fun FmsClient.listComplianceStatusPaginated(block: ListComplianceStatusRequest.Builder.() -> Unit): Flow<ListComplianceStatusResponse> =
    listComplianceStatusPaginated(ListComplianceStatusRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listComplianceStatusPaginated]
 * to access the nested member [PolicyComplianceStatus]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicyComplianceStatus]
 */
@JvmName("listComplianceStatusResponsePolicyComplianceStatus")
public fun Flow<ListComplianceStatusResponse>.policyComplianceStatusList(): Flow<PolicyComplianceStatus> =
    transform() { response ->
        response.policyComplianceStatusList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMemberAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMemberAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMemberAccountsResponse]
 */
public fun FmsClient.listMemberAccountsPaginated(initialRequest: ListMemberAccountsRequest): Flow<ListMemberAccountsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMemberAccountsPaginated.listMemberAccounts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMemberAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMemberAccountsResponse]
 */
public fun FmsClient.listMemberAccountsPaginated(block: ListMemberAccountsRequest.Builder.() -> Unit): Flow<ListMemberAccountsResponse> =
    listMemberAccountsPaginated(ListMemberAccountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMemberAccountsPaginated]
 * to access the nested member [AwsAccountId]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AwsAccountId]
 */
@JvmName("listMemberAccountsResponseAwsAccountId")
public fun Flow<ListMemberAccountsResponse>.memberAccounts(): Flow<String> =
    transform() { response ->
        response.memberAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesResponse]
 */
public fun FmsClient.listPoliciesPaginated(initialRequest: ListPoliciesRequest): Flow<ListPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPoliciesPaginated.listPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPoliciesResponse]
 */
public fun FmsClient.listPoliciesPaginated(block: ListPoliciesRequest.Builder.() -> Unit): Flow<ListPoliciesResponse> =
    listPoliciesPaginated(ListPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPoliciesPaginated]
 * to access the nested member [PolicySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PolicySummary]
 */
@JvmName("listPoliciesResponsePolicySummary")
public fun Flow<ListPoliciesResponse>.policyList(): Flow<PolicySummary> =
    transform() { response ->
        response.policyList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProtocolsListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProtocolsListsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProtocolsListsResponse]
 */
public fun FmsClient.listProtocolsListsPaginated(initialRequest: ListProtocolsListsRequest): Flow<ListProtocolsListsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProtocolsListsPaginated.listProtocolsLists(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListProtocolsListsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProtocolsListsResponse]
 */
public fun FmsClient.listProtocolsListsPaginated(block: ListProtocolsListsRequest.Builder.() -> Unit): Flow<ListProtocolsListsResponse> =
    listProtocolsListsPaginated(ListProtocolsListsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProtocolsListsPaginated]
 * to access the nested member [ProtocolsListDataSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProtocolsListDataSummary]
 */
@JvmName("listProtocolsListsResponseProtocolsListDataSummary")
public fun Flow<ListProtocolsListsResponse>.protocolsLists(): Flow<ProtocolsListDataSummary> =
    transform() { response ->
        response.protocolsLists?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListThirdPartyFirewallFirewallPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListThirdPartyFirewallFirewallPoliciesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListThirdPartyFirewallFirewallPoliciesResponse]
 */
public fun FmsClient.listThirdPartyFirewallFirewallPoliciesPaginated(initialRequest: ListThirdPartyFirewallFirewallPoliciesRequest): Flow<ListThirdPartyFirewallFirewallPoliciesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listThirdPartyFirewallFirewallPoliciesPaginated.listThirdPartyFirewallFirewallPolicies(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListThirdPartyFirewallFirewallPoliciesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListThirdPartyFirewallFirewallPoliciesResponse]
 */
public fun FmsClient.listThirdPartyFirewallFirewallPoliciesPaginated(block: ListThirdPartyFirewallFirewallPoliciesRequest.Builder.() -> Unit): Flow<ListThirdPartyFirewallFirewallPoliciesResponse> =
    listThirdPartyFirewallFirewallPoliciesPaginated(ListThirdPartyFirewallFirewallPoliciesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listThirdPartyFirewallFirewallPoliciesPaginated]
 * to access the nested member [ThirdPartyFirewallFirewallPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ThirdPartyFirewallFirewallPolicy]
 */
@JvmName("listThirdPartyFirewallFirewallPoliciesResponseThirdPartyFirewallFirewallPolicy")
public fun Flow<ListThirdPartyFirewallFirewallPoliciesResponse>.thirdPartyFirewallFirewallPolicies(): Flow<ThirdPartyFirewallFirewallPolicy> =
    transform() { response ->
        response.thirdPartyFirewallFirewallPolicies?.forEach {
            emit(it)
        }
    }
