// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fms.model.BatchAssociateResourceResponse
import aws.sdk.kotlin.services.fms.model.FailedItem
import aws.sdk.kotlin.services.fms.model.FmsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchAssociateResourceOperationDeserializer: HttpDeserialize<BatchAssociateResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchAssociateResourceResponse {
        if (!response.status.isSuccess()) {
            throwBatchAssociateResourceError(context, response)
        }
        val builder = BatchAssociateResourceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchAssociateResourceOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchAssociateResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> FmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchAssociateResourceOperationBody(builder: BatchAssociateResourceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FailedItems"))
    val RESOURCESETIDENTIFIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceSetIdentifier"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDITEMS_DESCRIPTOR)
        field(RESOURCESETIDENTIFIER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDITEMS_DESCRIPTOR.index -> builder.failedItems =
                    deserializer.deserializeList(FAILEDITEMS_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOURCESETIDENTIFIER_DESCRIPTOR.index -> builder.resourceSetIdentifier = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
