// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.fms.model.*
import aws.sdk.kotlin.services.fms.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "FMS"
public const val ServiceApiVersion: String = "2018-01-01"
public const val SdkVersion: String = "0.17.4-beta"

internal class DefaultFmsClient(override val config: FmsClient.Config) : FmsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Sets the Firewall Manager administrator account. The account must be a member of the organization in Organizations whose resources you want to protect. Firewall Manager sets the permissions that allow the account to administer your Firewall Manager policies.
     *
     * The account that you associate with Firewall Manager is called the Firewall Manager administrator account.
     */
    override suspend fun associateAdminAccount(input: AssociateAdminAccountRequest): AssociateAdminAccountResponse {
        val op = SdkHttpOperation.build<AssociateAdminAccountRequest, AssociateAdminAccountResponse> {
            serializer = AssociateAdminAccountOperationSerializer()
            deserializer = AssociateAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the Firewall Manager policy administrator as a tenant administrator of a third-party firewall service. A tenant is an instance of the third-party firewall service that's associated with your Amazon Web Services customer account.
     */
    override suspend fun associateThirdPartyFirewall(input: AssociateThirdPartyFirewallRequest): AssociateThirdPartyFirewallResponse {
        val op = SdkHttpOperation.build<AssociateThirdPartyFirewallRequest, AssociateThirdPartyFirewallResponse> {
            serializer = AssociateThirdPartyFirewallOperationSerializer()
            deserializer = AssociateThirdPartyFirewallOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateThirdPartyFirewall"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes an Firewall Manager applications list.
     */
    override suspend fun deleteAppsList(input: DeleteAppsListRequest): DeleteAppsListResponse {
        val op = SdkHttpOperation.build<DeleteAppsListRequest, DeleteAppsListResponse> {
            serializer = DeleteAppsListOperationSerializer()
            deserializer = DeleteAppsListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAppsList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an Firewall Manager association with the IAM role and the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.
     */
    override suspend fun deleteNotificationChannel(input: DeleteNotificationChannelRequest): DeleteNotificationChannelResponse {
        val op = SdkHttpOperation.build<DeleteNotificationChannelRequest, DeleteNotificationChannelResponse> {
            serializer = DeleteNotificationChannelOperationSerializer()
            deserializer = DeleteNotificationChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteNotificationChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes an Firewall Manager policy.
     */
    override suspend fun deletePolicy(input: DeletePolicyRequest): DeletePolicyResponse {
        val op = SdkHttpOperation.build<DeletePolicyRequest, DeletePolicyResponse> {
            serializer = DeletePolicyOperationSerializer()
            deserializer = DeletePolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Permanently deletes an Firewall Manager protocols list.
     */
    override suspend fun deleteProtocolsList(input: DeleteProtocolsListRequest): DeleteProtocolsListResponse {
        val op = SdkHttpOperation.build<DeleteProtocolsListRequest, DeleteProtocolsListResponse> {
            serializer = DeleteProtocolsListOperationSerializer()
            deserializer = DeleteProtocolsListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteProtocolsList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the account that has been set as the Firewall Manager administrator account. To set a different account as the administrator account, you must submit an `AssociateAdminAccount` request.
     */
    override suspend fun disassociateAdminAccount(input: DisassociateAdminAccountRequest): DisassociateAdminAccountResponse {
        val op = SdkHttpOperation.build<DisassociateAdminAccountRequest, DisassociateAdminAccountResponse> {
            serializer = DisassociateAdminAccountOperationSerializer()
            deserializer = DisassociateAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a Firewall Manager policy administrator from a third-party firewall tenant. When you call `DisassociateThirdPartyFirewall`, the third-party firewall vendor deletes all of the firewalls that are associated with the account.
     */
    override suspend fun disassociateThirdPartyFirewall(input: DisassociateThirdPartyFirewallRequest): DisassociateThirdPartyFirewallResponse {
        val op = SdkHttpOperation.build<DisassociateThirdPartyFirewallRequest, DisassociateThirdPartyFirewallResponse> {
            serializer = DisassociateThirdPartyFirewallOperationSerializer()
            deserializer = DisassociateThirdPartyFirewallOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateThirdPartyFirewall"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the Organizations account that is associated with Firewall Manager as the Firewall Manager administrator.
     */
    override suspend fun getAdminAccount(input: GetAdminAccountRequest): GetAdminAccountResponse {
        val op = SdkHttpOperation.build<GetAdminAccountRequest, GetAdminAccountResponse> {
            serializer = GetAdminAccountOperationSerializer()
            deserializer = GetAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified Firewall Manager applications list.
     */
    override suspend fun getAppsList(input: GetAppsListRequest): GetAppsListResponse {
        val op = SdkHttpOperation.build<GetAppsListRequest, GetAppsListResponse> {
            serializer = GetAppsListOperationSerializer()
            deserializer = GetAppsListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAppsList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed compliance information about the specified member account. Details include resources that are in and out of compliance with the specified policy.
     * + Resources are considered noncompliant for WAF and Shield Advanced policies if the specified policy has not been applied to them.
     * + Resources are considered noncompliant for security group policies if they are in scope of the policy, they violate one or more of the policy rules, and remediation is disabled or not possible.
     * + Resources are considered noncompliant for Network Firewall policies if a firewall is missing in the VPC, if the firewall endpoint isn't set up in an expected Availability Zone and subnet, if a subnet created by the Firewall Manager doesn't have the expected route table, and for modifications to a firewall policy that violate the Firewall Manager policy's rules.
     * + Resources are considered noncompliant for DNS Firewall policies if a DNS Firewall rule group is missing from the rule group associations for the VPC.
     */
    override suspend fun getComplianceDetail(input: GetComplianceDetailRequest): GetComplianceDetailResponse {
        val op = SdkHttpOperation.build<GetComplianceDetailRequest, GetComplianceDetailResponse> {
            serializer = GetComplianceDetailOperationSerializer()
            deserializer = GetComplianceDetailOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetComplianceDetail"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Information about the Amazon Simple Notification Service (SNS) topic that is used to record Firewall Manager SNS logs.
     */
    override suspend fun getNotificationChannel(input: GetNotificationChannelRequest): GetNotificationChannelResponse {
        val op = SdkHttpOperation.build<GetNotificationChannelRequest, GetNotificationChannelResponse> {
            serializer = GetNotificationChannelOperationSerializer()
            deserializer = GetNotificationChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetNotificationChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified Firewall Manager policy.
     */
    override suspend fun getPolicy(input: GetPolicyRequest): GetPolicyResponse {
        val op = SdkHttpOperation.build<GetPolicyRequest, GetPolicyResponse> {
            serializer = GetPolicyOperationSerializer()
            deserializer = GetPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * If you created a Shield Advanced policy, returns policy-level attack summary information in the event of a potential DDoS attack. Other policy types are currently unsupported.
     */
    override suspend fun getProtectionStatus(input: GetProtectionStatusRequest): GetProtectionStatusResponse {
        val op = SdkHttpOperation.build<GetProtectionStatusRequest, GetProtectionStatusResponse> {
            serializer = GetProtectionStatusOperationSerializer()
            deserializer = GetProtectionStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProtectionStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about the specified Firewall Manager protocols list.
     */
    override suspend fun getProtocolsList(input: GetProtocolsListRequest): GetProtocolsListResponse {
        val op = SdkHttpOperation.build<GetProtocolsListRequest, GetProtocolsListResponse> {
            serializer = GetProtocolsListOperationSerializer()
            deserializer = GetProtocolsListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetProtocolsList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The onboarding status of a Firewall Manager admin account to third-party firewall vendor tenant.
     */
    override suspend fun getThirdPartyFirewallAssociationStatus(input: GetThirdPartyFirewallAssociationStatusRequest): GetThirdPartyFirewallAssociationStatusResponse {
        val op = SdkHttpOperation.build<GetThirdPartyFirewallAssociationStatusRequest, GetThirdPartyFirewallAssociationStatusResponse> {
            serializer = GetThirdPartyFirewallAssociationStatusOperationSerializer()
            deserializer = GetThirdPartyFirewallAssociationStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetThirdPartyFirewallAssociationStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.
     */
    override suspend fun getViolationDetails(input: GetViolationDetailsRequest): GetViolationDetailsResponse {
        val op = SdkHttpOperation.build<GetViolationDetailsRequest, GetViolationDetailsResponse> {
            serializer = GetViolationDetailsOperationSerializer()
            deserializer = GetViolationDetailsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetViolationDetails"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `AppsListDataSummary` objects.
     */
    override suspend fun listAppsLists(input: ListAppsListsRequest): ListAppsListsResponse {
        val op = SdkHttpOperation.build<ListAppsListsRequest, ListAppsListsResponse> {
            serializer = ListAppsListsOperationSerializer()
            deserializer = ListAppsListsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAppsLists"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `PolicyComplianceStatus` objects. Use `PolicyComplianceStatus` to get a summary of which member accounts are protected by the specified policy.
     */
    override suspend fun listComplianceStatus(input: ListComplianceStatusRequest): ListComplianceStatusResponse {
        val op = SdkHttpOperation.build<ListComplianceStatusRequest, ListComplianceStatusResponse> {
            serializer = ListComplianceStatusOperationSerializer()
            deserializer = ListComplianceStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListComplianceStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a `MemberAccounts` object that lists the member accounts in the administrator's Amazon Web Services organization.
     *
     * The `ListMemberAccounts` must be submitted by the account that is set as the Firewall Manager administrator.
     */
    override suspend fun listMemberAccounts(input: ListMemberAccountsRequest): ListMemberAccountsResponse {
        val op = SdkHttpOperation.build<ListMemberAccountsRequest, ListMemberAccountsResponse> {
            serializer = ListMemberAccountsOperationSerializer()
            deserializer = ListMemberAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMemberAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `PolicySummary` objects.
     */
    override suspend fun listPolicies(input: ListPoliciesRequest): ListPoliciesResponse {
        val op = SdkHttpOperation.build<ListPoliciesRequest, ListPoliciesResponse> {
            serializer = ListPoliciesOperationSerializer()
            deserializer = ListPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of `ProtocolsListDataSummary` objects.
     */
    override suspend fun listProtocolsLists(input: ListProtocolsListsRequest): ListProtocolsListsResponse {
        val op = SdkHttpOperation.build<ListProtocolsListsRequest, ListProtocolsListsResponse> {
            serializer = ListProtocolsListsOperationSerializer()
            deserializer = ListProtocolsListsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListProtocolsLists"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the list of tags for the specified Amazon Web Services resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall administrator's account.
     */
    override suspend fun listThirdPartyFirewallFirewallPolicies(input: ListThirdPartyFirewallFirewallPoliciesRequest): ListThirdPartyFirewallFirewallPoliciesResponse {
        val op = SdkHttpOperation.build<ListThirdPartyFirewallFirewallPoliciesRequest, ListThirdPartyFirewallFirewallPoliciesResponse> {
            serializer = ListThirdPartyFirewallFirewallPoliciesOperationSerializer()
            deserializer = ListThirdPartyFirewallFirewallPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListThirdPartyFirewallFirewallPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Firewall Manager applications list.
     */
    override suspend fun putAppsList(input: PutAppsListRequest): PutAppsListResponse {
        val op = SdkHttpOperation.build<PutAppsListRequest, PutAppsListResponse> {
            serializer = PutAppsListOperationSerializer()
            deserializer = PutAppsListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutAppsList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Designates the IAM role and Amazon Simple Notification Service (SNS) topic that Firewall Manager uses to record SNS logs.
     *
     * To perform this action outside of the console, you must configure the SNS topic to allow the Firewall Manager role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *Firewall Manager Developer Guide*.
     */
    override suspend fun putNotificationChannel(input: PutNotificationChannelRequest): PutNotificationChannelResponse {
        val op = SdkHttpOperation.build<PutNotificationChannelRequest, PutNotificationChannelResponse> {
            serializer = PutNotificationChannelOperationSerializer()
            deserializer = PutNotificationChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutNotificationChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Firewall Manager policy.
     *
     * Firewall Manager provides the following types of policies:
     * + An WAF policy (type WAFV2), which defines rule groups to run first in the corresponding WAF web ACL and rule groups to run last in the web ACL.
     * + An WAF Classic policy (type WAF), which defines a rule group.
     * + A Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
     * + A security group policy, which manages VPC security groups across your Amazon Web Services organization.
     * + An Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
     * + A DNS Firewall policy, which provides Route 53 Resolver DNS Firewall rules to filter DNS queries for specified VPCs.
     *
     * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
     *
     * You must be subscribed to Shield Advanced to create a Shield Advanced policy. For more information about subscribing to Shield Advanced, see [CreateSubscription](https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html).
     */
    override suspend fun putPolicy(input: PutPolicyRequest): PutPolicyResponse {
        val op = SdkHttpOperation.build<PutPolicyRequest, PutPolicyResponse> {
            serializer = PutPolicyOperationSerializer()
            deserializer = PutPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an Firewall Manager protocols list.
     */
    override suspend fun putProtocolsList(input: PutProtocolsListRequest): PutProtocolsListResponse {
        val op = SdkHttpOperation.build<PutProtocolsListRequest, PutProtocolsListResponse> {
            serializer = PutProtocolsListOperationSerializer()
            deserializer = PutProtocolsListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutProtocolsList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to an Amazon Web Services resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from an Amazon Web Services resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("AWSFMS_20180101", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "fms"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "fms")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
