// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "fms.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "af-south-1" to EndpointDefinition(),
            "ap-east-1" to EndpointDefinition(),
            "ap-northeast-1" to EndpointDefinition(),
            "ap-northeast-2" to EndpointDefinition(),
            "ap-northeast-3" to EndpointDefinition(),
            "ap-south-1" to EndpointDefinition(),
            "ap-southeast-1" to EndpointDefinition(),
            "ap-southeast-2" to EndpointDefinition(),
            "ca-central-1" to EndpointDefinition(),
            "eu-central-1" to EndpointDefinition(),
            "eu-north-1" to EndpointDefinition(),
            "eu-south-1" to EndpointDefinition(),
            "eu-west-1" to EndpointDefinition(),
            "eu-west-2" to EndpointDefinition(),
            "eu-west-3" to EndpointDefinition(),
            "fips-af-south-1" to EndpointDefinition(
                hostname = "fms-fips.af-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "af-south-1",),
            ),
            "fips-ap-east-1" to EndpointDefinition(
                hostname = "fms-fips.ap-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-east-1",),
            ),
            "fips-ap-northeast-1" to EndpointDefinition(
                hostname = "fms-fips.ap-northeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-1",),
            ),
            "fips-ap-northeast-2" to EndpointDefinition(
                hostname = "fms-fips.ap-northeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-northeast-2",),
            ),
            "fips-ap-south-1" to EndpointDefinition(
                hostname = "fms-fips.ap-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-south-1",),
            ),
            "fips-ap-southeast-1" to EndpointDefinition(
                hostname = "fms-fips.ap-southeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-1",),
            ),
            "fips-ap-southeast-2" to EndpointDefinition(
                hostname = "fms-fips.ap-southeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-2",),
            ),
            "fips-ca-central-1" to EndpointDefinition(
                hostname = "fms-fips.ca-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ca-central-1",),
            ),
            "fips-eu-central-1" to EndpointDefinition(
                hostname = "fms-fips.eu-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-central-1",),
            ),
            "fips-eu-south-1" to EndpointDefinition(
                hostname = "fms-fips.eu-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-south-1",),
            ),
            "fips-eu-west-1" to EndpointDefinition(
                hostname = "fms-fips.eu-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-1",),
            ),
            "fips-eu-west-2" to EndpointDefinition(
                hostname = "fms-fips.eu-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-2",),
            ),
            "fips-eu-west-3" to EndpointDefinition(
                hostname = "fms-fips.eu-west-3.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-3",),
            ),
            "fips-me-south-1" to EndpointDefinition(
                hostname = "fms-fips.me-south-1.amazonaws.com",
                credentialScope = CredentialScope(region = "me-south-1",),
            ),
            "fips-sa-east-1" to EndpointDefinition(
                hostname = "fms-fips.sa-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "sa-east-1",),
            ),
            "fips-us-east-1" to EndpointDefinition(
                hostname = "fms-fips.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "fips-us-east-2" to EndpointDefinition(
                hostname = "fms-fips.us-east-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-2",),
            ),
            "fips-us-west-1" to EndpointDefinition(
                hostname = "fms-fips.us-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-1",),
            ),
            "fips-us-west-2" to EndpointDefinition(
                hostname = "fms-fips.us-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-2",),
            ),
            "me-south-1" to EndpointDefinition(),
            "sa-east-1" to EndpointDefinition(),
            "us-east-1" to EndpointDefinition(),
            "us-east-2" to EndpointDefinition(),
            "us-west-1" to EndpointDefinition(),
            "us-west-2" to EndpointDefinition(),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "fms.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "cn-north-1" to EndpointDefinition(),
            "cn-northwest-1" to EndpointDefinition(),
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "fms.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "fms.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "fms.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "fips-us-gov-east-1" to EndpointDefinition(
                hostname = "fms-fips.us-gov-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-east-1",),
            ),
            "fips-us-gov-west-1" to EndpointDefinition(
                hostname = "fms-fips.us-gov-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-gov-west-1",),
            ),
            "us-gov-east-1" to EndpointDefinition(),
            "us-gov-west-1" to EndpointDefinition(),
        )
    ),
)
