// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Firewall Manager applications list.
 */
public class AppsListData private constructor(builder: Builder) {
    /**
     * An array of applications in the Firewall Manager applications list.
     */
    public val appsList: List<App>? = builder.appsList
    /**
     * The time that the Firewall Manager applications list was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The time that the Firewall Manager applications list was last updated.
     */
    public val lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateTime
    /**
     * The ID of the Firewall Manager applications list.
     */
    public val listId: kotlin.String? = builder.listId
    /**
     * The name of the Firewall Manager applications list.
     */
    public val listName: kotlin.String? = builder.listName
    /**
     * A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list.
     */
    public val listUpdateToken: kotlin.String? = builder.listUpdateToken
    /**
     * A map of previous version numbers to their corresponding `App` object arrays.
     */
    public val previousAppsList: Map<String, List<App>>? = builder.previousAppsList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.AppsListData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppsListData(")
        append("appsList=$appsList,")
        append("createTime=$createTime,")
        append("lastUpdateTime=$lastUpdateTime,")
        append("listId=$listId,")
        append("listName=$listName,")
        append("listUpdateToken=$listUpdateToken,")
        append("previousAppsList=$previousAppsList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appsList?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (listId?.hashCode() ?: 0)
        result = 31 * result + (listName?.hashCode() ?: 0)
        result = 31 * result + (listUpdateToken?.hashCode() ?: 0)
        result = 31 * result + (previousAppsList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppsListData

        if (appsList != other.appsList) return false
        if (createTime != other.createTime) return false
        if (lastUpdateTime != other.lastUpdateTime) return false
        if (listId != other.listId) return false
        if (listName != other.listName) return false
        if (listUpdateToken != other.listUpdateToken) return false
        if (previousAppsList != other.previousAppsList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.AppsListData = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of applications in the Firewall Manager applications list.
         */
        public var appsList: List<App>? = null
        /**
         * The time that the Firewall Manager applications list was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the Firewall Manager applications list was last updated.
         */
        public var lastUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the Firewall Manager applications list.
         */
        public var listId: kotlin.String? = null
        /**
         * The name of the Firewall Manager applications list.
         */
        public var listName: kotlin.String? = null
        /**
         * A unique identifier for each update to the list. When you update the list, the update token must match the token of the current version of the application list. You can retrieve the update token by getting the list.
         */
        public var listUpdateToken: kotlin.String? = null
        /**
         * A map of previous version numbers to their corresponding `App` object arrays.
         */
        public var previousAppsList: Map<String, List<App>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.AppsListData) : this() {
            this.appsList = x.appsList
            this.createTime = x.createTime
            this.lastUpdateTime = x.lastUpdateTime
            this.listId = x.listId
            this.listName = x.listName
            this.listUpdateToken = x.listUpdateToken
            this.previousAppsList = x.previousAppsList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.AppsListData = AppsListData(this)
    }
}
