// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



public class DeletePolicyRequest private constructor(builder: Builder) {
    /**
     * If `True`, the request performs cleanup according to the policy type.
     *
     * For WAF and Shield Advanced policies, the cleanup does the following:
     * + Deletes rule groups created by Firewall Manager
     * + Removes web ACLs from in-scope resources
     * + Deletes web ACLs that contain no rules or rule groups
     *
     * For security group policies, the cleanup does the following for each security group in the policy:
     * + Disassociates the security group from in-scope resources
     * + Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy
     *
     * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
     */
    public val deleteAllPolicyResources: kotlin.Boolean = builder.deleteAllPolicyResources
    /**
     * The ID of the policy that you want to delete. You can retrieve this ID from `PutPolicy` and `ListPolicies`.
     */
    public val policyId: kotlin.String? = builder.policyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.DeletePolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeletePolicyRequest(")
        append("deleteAllPolicyResources=$deleteAllPolicyResources,")
        append("policyId=$policyId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteAllPolicyResources.hashCode()
        result = 31 * result + (policyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeletePolicyRequest

        if (deleteAllPolicyResources != other.deleteAllPolicyResources) return false
        if (policyId != other.policyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.DeletePolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * If `True`, the request performs cleanup according to the policy type.
         *
         * For WAF and Shield Advanced policies, the cleanup does the following:
         * + Deletes rule groups created by Firewall Manager
         * + Removes web ACLs from in-scope resources
         * + Deletes web ACLs that contain no rules or rule groups
         *
         * For security group policies, the cleanup does the following for each security group in the policy:
         * + Disassociates the security group from in-scope resources
         * + Deletes the security group if it was created through Firewall Manager and if it's no longer associated with any resources through another policy
         *
         * After the cleanup, in-scope resources are no longer protected by web ACLs in this policy. Protection of out-of-scope resources remains unchanged. Scope is determined by tags that you create and accounts that you associate with the policy. When creating the policy, if you specify that only resources in specific accounts or with specific tags are in scope of the policy, those accounts and resources are handled by the policy. All others are out of scope. If you don't specify tags or accounts, all resources are in scope.
         */
        public var deleteAllPolicyResources: kotlin.Boolean = false
        /**
         * The ID of the policy that you want to delete. You can retrieve this ID from `PutPolicy` and `ListPolicies`.
         */
        public var policyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.DeletePolicyRequest) : this() {
            this.deleteAllPolicyResources = x.deleteAllPolicyResources
            this.policyId = x.policyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.DeletePolicyRequest = DeletePolicyRequest(this)
    }
}
