// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetProtectionStatusRequest private constructor(builder: Builder) {
    /**
     * The end of the time period to query for the attacks. This is a `timestamp` type. The request syntax listing indicates a `number` type because the default used by Firewall Manager is Unix time in seconds. However, any valid `timestamp` format is allowed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Specifies the number of objects that you want Firewall Manager to return for this request. If you have more objects than the number that you specify for `MaxResults`, the response includes a `NextToken` value that you can use to get another batch of objects.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The Amazon Web Services account that is in scope of the policy that you want to get the details for.
     */
    public val memberAccountId: kotlin.String? = builder.memberAccountId
    /**
     * If you specify a value for `MaxResults` and you have more objects than the number that you specify for `MaxResults`, Firewall Manager returns a `NextToken` value in the response, which you can use to retrieve another group of objects. For the second and subsequent `GetProtectionStatus` requests, specify the value of `NextToken` from the previous response to get information about another batch of objects.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ID of the policy for which you want to get the attack information.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The start of the time period to query for the attacks. This is a `timestamp` type. The request syntax listing indicates a `number` type because the default used by Firewall Manager is Unix time in seconds. However, any valid `timestamp` format is allowed.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.GetProtectionStatusRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetProtectionStatusRequest(")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("memberAccountId=$memberAccountId,")
        append("nextToken=$nextToken,")
        append("policyId=$policyId,")
        append("startTime=$startTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (memberAccountId?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetProtectionStatusRequest

        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (memberAccountId != other.memberAccountId) return false
        if (nextToken != other.nextToken) return false
        if (policyId != other.policyId) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.GetProtectionStatusRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The end of the time period to query for the attacks. This is a `timestamp` type. The request syntax listing indicates a `number` type because the default used by Firewall Manager is Unix time in seconds. However, any valid `timestamp` format is allowed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the number of objects that you want Firewall Manager to return for this request. If you have more objects than the number that you specify for `MaxResults`, the response includes a `NextToken` value that you can use to get another batch of objects.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The Amazon Web Services account that is in scope of the policy that you want to get the details for.
         */
        public var memberAccountId: kotlin.String? = null
        /**
         * If you specify a value for `MaxResults` and you have more objects than the number that you specify for `MaxResults`, Firewall Manager returns a `NextToken` value in the response, which you can use to retrieve another group of objects. For the second and subsequent `GetProtectionStatus` requests, specify the value of `NextToken` from the previous response to get information about another batch of objects.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The ID of the policy for which you want to get the attack information.
         */
        public var policyId: kotlin.String? = null
        /**
         * The start of the time period to query for the attacks. This is a `timestamp` type. The request syntax listing indicates a `number` type because the default used by Firewall Manager is Unix time in seconds. However, any valid `timestamp` format is allowed.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.GetProtectionStatusRequest) : this() {
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.memberAccountId = x.memberAccountId
            this.nextToken = x.nextToken
            this.policyId = x.policyId
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.GetProtectionStatusRequest = GetProtectionStatusRequest(this)
    }
}
