// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



public class GetProtectionStatusResponse private constructor(builder: Builder) {
    /**
     * The ID of the Firewall Manager administrator account for this policy.
     */
    public val adminAccountId: kotlin.String? = builder.adminAccountId
    /**
     * Details about the attack, including the following:
     * + Attack type
     * + Account ID
     * + ARN of the resource attacked
     * + Start time of the attack
     * + End time of the attack (ongoing attacks will not have an end time)
     *
     * The details are in JSON format.
     */
    public val data: kotlin.String? = builder.data
    /**
     * If you have more objects than the number that you specified for `MaxResults` in the request, the response includes a `NextToken` value. To list more objects, submit another `GetProtectionStatus` request, and specify the `NextToken` value from the response in the `NextToken` value in the next request.
     *
     * Amazon Web Services SDKs provide auto-pagination that identify `NextToken` in a response and make subsequent request calls automatically on your behalf. However, this feature is not supported by `GetProtectionStatus`. You must submit subsequent requests with `NextToken` using your own processes.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The service type that is protected by the policy. Currently, this is always `SHIELD_ADVANCED`.
     */
    public val serviceType: aws.sdk.kotlin.services.fms.model.SecurityServiceType? = builder.serviceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.GetProtectionStatusResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetProtectionStatusResponse(")
        append("adminAccountId=$adminAccountId,")
        append("data=$data,")
        append("nextToken=$nextToken,")
        append("serviceType=$serviceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = adminAccountId?.hashCode() ?: 0
        result = 31 * result + (data?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetProtectionStatusResponse

        if (adminAccountId != other.adminAccountId) return false
        if (data != other.data) return false
        if (nextToken != other.nextToken) return false
        if (serviceType != other.serviceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.GetProtectionStatusResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Firewall Manager administrator account for this policy.
         */
        public var adminAccountId: kotlin.String? = null
        /**
         * Details about the attack, including the following:
         * + Attack type
         * + Account ID
         * + ARN of the resource attacked
         * + Start time of the attack
         * + End time of the attack (ongoing attacks will not have an end time)
         *
         * The details are in JSON format.
         */
        public var data: kotlin.String? = null
        /**
         * If you have more objects than the number that you specified for `MaxResults` in the request, the response includes a `NextToken` value. To list more objects, submit another `GetProtectionStatus` request, and specify the `NextToken` value from the response in the `NextToken` value in the next request.
         *
         * Amazon Web Services SDKs provide auto-pagination that identify `NextToken` in a response and make subsequent request calls automatically on your behalf. However, this feature is not supported by `GetProtectionStatus`. You must submit subsequent requests with `NextToken` using your own processes.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The service type that is protected by the policy. Currently, this is always `SHIELD_ADVANCED`.
         */
        public var serviceType: aws.sdk.kotlin.services.fms.model.SecurityServiceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.GetProtectionStatusResponse) : this() {
            this.adminAccountId = x.adminAccountId
            this.data = x.data
            this.nextToken = x.nextToken
            this.serviceType = x.serviceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.GetProtectionStatusResponse = GetProtectionStatusResponse(this)
    }
}
