// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the noncompliant resources in a member account for a specific Firewall Manager policy. A maximum of 100 entries are displayed. If more than 100 resources are noncompliant, `EvaluationLimitExceeded` is set to `True`.
 */
public class PolicyComplianceDetail private constructor(builder: Builder) {
    /**
     * Indicates if over 100 resources are noncompliant with the Firewall Manager policy.
     */
    public val evaluationLimitExceeded: kotlin.Boolean = builder.evaluationLimitExceeded
    /**
     * A timestamp that indicates when the returned information should be considered out of date.
     */
    public val expiredAt: aws.smithy.kotlin.runtime.time.Instant? = builder.expiredAt
    /**
     * Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.
     */
    public val issueInfoMap: Map<String, String>? = builder.issueInfoMap
    /**
     * The Amazon Web Services account ID.
     */
    public val memberAccount: kotlin.String? = builder.memberAccount
    /**
     * The ID of the Firewall Manager policy.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The Amazon Web Services account that created the Firewall Manager policy.
     */
    public val policyOwner: kotlin.String? = builder.policyOwner
    /**
     * An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance with the security group policy.
     */
    public val violators: List<ComplianceViolator>? = builder.violators

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.PolicyComplianceDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicyComplianceDetail(")
        append("evaluationLimitExceeded=$evaluationLimitExceeded,")
        append("expiredAt=$expiredAt,")
        append("issueInfoMap=$issueInfoMap,")
        append("memberAccount=$memberAccount,")
        append("policyId=$policyId,")
        append("policyOwner=$policyOwner,")
        append("violators=$violators)")
    }

    override fun hashCode(): kotlin.Int {
        var result = evaluationLimitExceeded.hashCode()
        result = 31 * result + (expiredAt?.hashCode() ?: 0)
        result = 31 * result + (issueInfoMap?.hashCode() ?: 0)
        result = 31 * result + (memberAccount?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyOwner?.hashCode() ?: 0)
        result = 31 * result + (violators?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicyComplianceDetail

        if (evaluationLimitExceeded != other.evaluationLimitExceeded) return false
        if (expiredAt != other.expiredAt) return false
        if (issueInfoMap != other.issueInfoMap) return false
        if (memberAccount != other.memberAccount) return false
        if (policyId != other.policyId) return false
        if (policyOwner != other.policyOwner) return false
        if (violators != other.violators) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.PolicyComplianceDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates if over 100 resources are noncompliant with the Firewall Manager policy.
         */
        public var evaluationLimitExceeded: kotlin.Boolean = false
        /**
         * A timestamp that indicates when the returned information should be considered out of date.
         */
        public var expiredAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Details about problems with dependent services, such as WAF or Config, and the error message received that indicates the problem with the service.
         */
        public var issueInfoMap: Map<String, String>? = null
        /**
         * The Amazon Web Services account ID.
         */
        public var memberAccount: kotlin.String? = null
        /**
         * The ID of the Firewall Manager policy.
         */
        public var policyId: kotlin.String? = null
        /**
         * The Amazon Web Services account that created the Firewall Manager policy.
         */
        public var policyOwner: kotlin.String? = null
        /**
         * An array of resources that aren't protected by the WAF or Shield Advanced policy or that aren't in compliance with the security group policy.
         */
        public var violators: List<ComplianceViolator>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.PolicyComplianceDetail) : this() {
            this.evaluationLimitExceeded = x.evaluationLimitExceeded
            this.expiredAt = x.expiredAt
            this.issueInfoMap = x.issueInfoMap
            this.memberAccount = x.memberAccount
            this.policyId = x.policyId
            this.policyOwner = x.policyOwner
            this.violators = x.violators
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.PolicyComplianceDetail = PolicyComplianceDetail(this)
    }
}
