// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * Details of the Firewall Manager policy.
 */
public class PolicySummary private constructor(builder: Builder) {
    /**
     * Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
     *
     * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
     *
     * This option is not available for Shield Advanced or WAF Classic policies.
     */
    public val deleteUnusedFmManagedResources: kotlin.Boolean = builder.deleteUnusedFmManagedResources
    /**
     * The Amazon Resource Name (ARN) of the specified policy.
     */
    public val policyArn: kotlin.String? = builder.policyArn
    /**
     * The ID of the specified policy.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * The name of the specified policy.
     */
    public val policyName: kotlin.String? = builder.policyName
    /**
     * Indicates if the policy should be automatically applied to new resources.
     */
    public val remediationEnabled: kotlin.Boolean = builder.remediationEnabled
    /**
     * The type of resource protected by or in scope of the policy. This is in the format shown in the [Amazon Web Services Resource Types Reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html). For WAF and Shield Advanced, examples include `AWS::ElasticLoadBalancingV2::LoadBalancer` and `AWS::CloudFront::Distribution`. For a security group common policy, valid values are `AWS::EC2::NetworkInterface` and `AWS::EC2::Instance`. For a security group content audit policy, valid values are `AWS::EC2::SecurityGroup`, `AWS::EC2::NetworkInterface`, and `AWS::EC2::Instance`. For a security group usage audit policy, the value is `AWS::EC2::SecurityGroup`. For an Network Firewall policy or DNS Firewall policy, the value is `AWS::EC2::VPC`.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy.
     */
    public val securityServiceType: aws.sdk.kotlin.services.fms.model.SecurityServiceType? = builder.securityServiceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.PolicySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PolicySummary(")
        append("deleteUnusedFmManagedResources=$deleteUnusedFmManagedResources,")
        append("policyArn=$policyArn,")
        append("policyId=$policyId,")
        append("policyName=$policyName,")
        append("remediationEnabled=$remediationEnabled,")
        append("resourceType=$resourceType,")
        append("securityServiceType=$securityServiceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteUnusedFmManagedResources.hashCode()
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (policyName?.hashCode() ?: 0)
        result = 31 * result + (remediationEnabled.hashCode())
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (securityServiceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PolicySummary

        if (deleteUnusedFmManagedResources != other.deleteUnusedFmManagedResources) return false
        if (policyArn != other.policyArn) return false
        if (policyId != other.policyId) return false
        if (policyName != other.policyName) return false
        if (remediationEnabled != other.remediationEnabled) return false
        if (resourceType != other.resourceType) return false
        if (securityServiceType != other.securityServiceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.PolicySummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether Firewall Manager should automatically remove protections from resources that leave the policy scope and clean up resources that Firewall Manager is managing for accounts when those accounts leave policy scope. For example, Firewall Manager will disassociate a Firewall Manager managed web ACL from a protected customer resource when the customer resource leaves policy scope.
         *
         * By default, Firewall Manager doesn't remove protections or delete Firewall Manager managed resources.
         *
         * This option is not available for Shield Advanced or WAF Classic policies.
         */
        public var deleteUnusedFmManagedResources: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of the specified policy.
         */
        public var policyArn: kotlin.String? = null
        /**
         * The ID of the specified policy.
         */
        public var policyId: kotlin.String? = null
        /**
         * The name of the specified policy.
         */
        public var policyName: kotlin.String? = null
        /**
         * Indicates if the policy should be automatically applied to new resources.
         */
        public var remediationEnabled: kotlin.Boolean = false
        /**
         * The type of resource protected by or in scope of the policy. This is in the format shown in the [Amazon Web Services Resource Types Reference](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html). For WAF and Shield Advanced, examples include `AWS::ElasticLoadBalancingV2::LoadBalancer` and `AWS::CloudFront::Distribution`. For a security group common policy, valid values are `AWS::EC2::NetworkInterface` and `AWS::EC2::Instance`. For a security group content audit policy, valid values are `AWS::EC2::SecurityGroup`, `AWS::EC2::NetworkInterface`, and `AWS::EC2::Instance`. For a security group usage audit policy, the value is `AWS::EC2::SecurityGroup`. For an Network Firewall policy or DNS Firewall policy, the value is `AWS::EC2::VPC`.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The service that the policy is using to protect the resources. This specifies the type of policy that is created, either an WAF policy, a Shield Advanced policy, or a security group policy.
         */
        public var securityServiceType: aws.sdk.kotlin.services.fms.model.SecurityServiceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.PolicySummary) : this() {
            this.deleteUnusedFmManagedResources = x.deleteUnusedFmManagedResources
            this.policyArn = x.policyArn
            this.policyId = x.policyId
            this.policyName = x.policyName
            this.remediationEnabled = x.remediationEnabled
            this.resourceType = x.resourceType
            this.securityServiceType = x.securityServiceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.PolicySummary = PolicySummary(this)
    }
}
