// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * The resource tags that Firewall Manager uses to determine if a particular resource should be included or excluded from the Firewall Manager policy. Tags enable you to categorize your Amazon Web Services resources in different ways, for example, by purpose, owner, or environment. Each tag consists of a key and an optional value. Firewall Manager combines the tags with "AND" so that, if you add more than one tag to a policy scope, a resource must have all the specified tags to be included or excluded. For more information, see [Working with Tag Editor](https://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/tag-editor.html).
 */
public class ResourceTag private constructor(builder: Builder) {
    /**
     * The resource tag key.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The resource tag value.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.ResourceTag = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceTag(")
        append("key=$key,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceTag

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.ResourceTag = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The resource tag key.
         */
        public var key: kotlin.String? = null
        /**
         * The resource tag value.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.ResourceTag) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.ResourceTag = ResourceTag(this)
    }
}
