// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * Network Firewall stateful rule group, used in a NetworkFirewallPolicyDescription.
 */
public class StatefulRuleGroup private constructor(builder: Builder) {
    /**
     * An integer setting that indicates the order in which to run the stateful rule groups in a single Network Firewall firewall policy. This setting only applies to firewall policies that specify the `STRICT_ORDER` rule order in the stateful engine options settings.
     *
     *  Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy. For information about
     *
     *  You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * The resource ID of the rule group.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The name of the rule group.
     */
    public val ruleGroupName: kotlin.String? = builder.ruleGroupName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.StatefulRuleGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StatefulRuleGroup(")
        append("priority=$priority,")
        append("resourceId=$resourceId,")
        append("ruleGroupName=$ruleGroupName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = priority ?: 0
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (ruleGroupName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StatefulRuleGroup

        if (priority != other.priority) return false
        if (resourceId != other.resourceId) return false
        if (ruleGroupName != other.ruleGroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.StatefulRuleGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An integer setting that indicates the order in which to run the stateful rule groups in a single Network Firewall firewall policy. This setting only applies to firewall policies that specify the `STRICT_ORDER` rule order in the stateful engine options settings.
         *
         *  Network Firewall evalutes each stateful rule group against a packet starting with the group that has the lowest priority setting. You must ensure that the priority settings are unique within each policy. For information about
         *
         *  You can change the priority settings of your rule groups at any time. To make it easier to insert rule groups later, number them so there's a wide range in between, for example use 100, 200, and so on.
         */
        public var priority: kotlin.Int? = null
        /**
         * The resource ID of the rule group.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The name of the rule group.
         */
        public var ruleGroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.StatefulRuleGroup) : this() {
            this.priority = x.priority
            this.resourceId = x.resourceId
            this.ruleGroupName = x.ruleGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.StatefulRuleGroup = StatefulRuleGroup(this)
    }
}
