// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * Violations for a resource based on the specified Firewall Manager policy and Amazon Web Services account.
 */
public class ViolationDetail private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account that the violation details were requested for.
     */
    public val memberAccount: kotlin.String? = builder.memberAccount
    /**
     * The ID of the Firewall Manager policy that the violation details were requested for.
     */
    public val policyId: kotlin.String? = builder.policyId
    /**
     * Brief description for the requested resource.
     */
    public val resourceDescription: kotlin.String? = builder.resourceDescription
    /**
     * The resource ID that the violation details were requested for.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The `ResourceTag` objects associated with the resource.
     */
    public val resourceTags: List<Tag>? = builder.resourceTags
    /**
     * The resource type that the violation details were requested for.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * List of violations for the requested resource.
     */
    public val resourceViolations: List<ResourceViolation>? = builder.resourceViolations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.ViolationDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ViolationDetail(")
        append("memberAccount=$memberAccount,")
        append("policyId=$policyId,")
        append("resourceDescription=$resourceDescription,")
        append("resourceId=$resourceId,")
        append("resourceTags=$resourceTags,")
        append("resourceType=$resourceType,")
        append("resourceViolations=$resourceViolations)")
    }

    override fun hashCode(): kotlin.Int {
        var result = memberAccount?.hashCode() ?: 0
        result = 31 * result + (policyId?.hashCode() ?: 0)
        result = 31 * result + (resourceDescription?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceTags?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (resourceViolations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ViolationDetail

        if (memberAccount != other.memberAccount) return false
        if (policyId != other.policyId) return false
        if (resourceDescription != other.resourceDescription) return false
        if (resourceId != other.resourceId) return false
        if (resourceTags != other.resourceTags) return false
        if (resourceType != other.resourceType) return false
        if (resourceViolations != other.resourceViolations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.ViolationDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account that the violation details were requested for.
         */
        public var memberAccount: kotlin.String? = null
        /**
         * The ID of the Firewall Manager policy that the violation details were requested for.
         */
        public var policyId: kotlin.String? = null
        /**
         * Brief description for the requested resource.
         */
        public var resourceDescription: kotlin.String? = null
        /**
         * The resource ID that the violation details were requested for.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The `ResourceTag` objects associated with the resource.
         */
        public var resourceTags: List<Tag>? = null
        /**
         * The resource type that the violation details were requested for.
         */
        public var resourceType: kotlin.String? = null
        /**
         * List of violations for the requested resource.
         */
        public var resourceViolations: List<ResourceViolation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.ViolationDetail) : this() {
            this.memberAccount = x.memberAccount
            this.policyId = x.policyId
            this.resourceDescription = x.resourceDescription
            this.resourceId = x.resourceId
            this.resourceTags = x.resourceTags
            this.resourceType = x.resourceType
            this.resourceViolations = x.resourceViolations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.ViolationDetail = ViolationDetail(this)
    }
}
