// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fms.model.AccountRoleStatus
import aws.sdk.kotlin.services.fms.model.FmsException
import aws.sdk.kotlin.services.fms.model.GetAdminAccountResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetAdminAccountOperationDeserializer: HttpDeserialize<GetAdminAccountResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetAdminAccountResponse {
        if (!response.status.isSuccess()) {
            throwGetAdminAccountError(context, response)
        }
        val builder = GetAdminAccountResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetAdminAccountOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetAdminAccountError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> FmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetAdminAccountOperationBody(builder: GetAdminAccountResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADMINACCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AdminAccount"))
    val ROLESTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADMINACCOUNT_DESCRIPTOR)
        field(ROLESTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADMINACCOUNT_DESCRIPTOR.index -> builder.adminAccount = deserializeString()
                ROLESTATUS_DESCRIPTOR.index -> builder.roleStatus = deserializeString().let { AccountRoleStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
