// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fms.model.FmsException
import aws.sdk.kotlin.services.fms.model.GetProtectionStatusResponse
import aws.sdk.kotlin.services.fms.model.SecurityServiceType
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetProtectionStatusOperationDeserializer: HttpDeserialize<GetProtectionStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetProtectionStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetProtectionStatusError(context, response)
        }
        val builder = GetProtectionStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetProtectionStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetProtectionStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> FmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetProtectionStatusOperationBody(builder: GetProtectionStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADMINACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AdminAccountId"))
    val DATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Data"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SERVICETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADMINACCOUNTID_DESCRIPTOR)
        field(DATA_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SERVICETYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADMINACCOUNTID_DESCRIPTOR.index -> builder.adminAccountId = deserializeString()
                DATA_DESCRIPTOR.index -> builder.data = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SERVICETYPE_DESCRIPTOR.index -> builder.serviceType = deserializeString().let { SecurityServiceType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
