// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fms.model.FmsException
import aws.sdk.kotlin.services.fms.model.GetProtocolsListResponse
import aws.sdk.kotlin.services.fms.model.ProtocolsListData
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetProtocolsListOperationDeserializer: HttpDeserialize<GetProtocolsListResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetProtocolsListResponse {
        if (!response.status.isSuccess()) {
            throwGetProtocolsListError(context, response)
        }
        val builder = GetProtocolsListResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetProtocolsListOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetProtocolsListError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> FmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetProtocolsListOperationBody(builder: GetProtocolsListResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROTOCOLSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProtocolsList"))
    val PROTOCOLSLISTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProtocolsListArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROTOCOLSLIST_DESCRIPTOR)
        field(PROTOCOLSLISTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROTOCOLSLIST_DESCRIPTOR.index -> builder.protocolsList = deserializeProtocolsListDataDocument(deserializer)
                PROTOCOLSLISTARN_DESCRIPTOR.index -> builder.protocolsListArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
