// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.fms.model.FmsException
import aws.sdk.kotlin.services.fms.model.ProtocolsListData
import aws.sdk.kotlin.services.fms.model.PutProtocolsListResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutProtocolsListOperationDeserializer: HttpDeserialize<PutProtocolsListResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutProtocolsListResponse {
        if (!response.status.isSuccess()) {
            throwPutProtocolsListError(context, response)
        }
        val builder = PutProtocolsListResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutProtocolsListOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutProtocolsListError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw FmsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalErrorException" -> InternalErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> FmsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutProtocolsListOperationBody(builder: PutProtocolsListResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROTOCOLSLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProtocolsList"))
    val PROTOCOLSLISTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProtocolsListArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROTOCOLSLIST_DESCRIPTOR)
        field(PROTOCOLSLISTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROTOCOLSLIST_DESCRIPTOR.index -> builder.protocolsList = deserializeProtocolsListDataDocument(deserializer)
                PROTOCOLSLISTARN_DESCRIPTOR.index -> builder.protocolsListArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
