// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.fms.model



/**
 * Information about the ReplaceRoute action in Amazon EC2.
 */
public class Ec2ReplaceRouteAction private constructor(builder: Builder) {
    /**
     * A description of the ReplaceRoute action in Amazon EC2.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Information about the IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.
     */
    public val destinationCidrBlock: kotlin.String? = builder.destinationCidrBlock
    /**
     * Information about the IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.
     */
    public val destinationIpv6CidrBlock: kotlin.String? = builder.destinationIpv6CidrBlock
    /**
     * Information about the ID of the prefix list for the route.
     */
    public val destinationPrefixListId: kotlin.String? = builder.destinationPrefixListId
    /**
     * Information about the ID of an internet gateway or virtual private gateway.
     */
    public val gatewayId: aws.sdk.kotlin.services.fms.model.ActionTarget? = builder.gatewayId
    /**
     * Information about the ID of the route table.
     */
    public val routeTableId: aws.sdk.kotlin.services.fms.model.ActionTarget? = builder.routeTableId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.fms.model.Ec2ReplaceRouteAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2ReplaceRouteAction(")
        append("description=$description,")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("destinationIpv6CidrBlock=$destinationIpv6CidrBlock,")
        append("destinationPrefixListId=$destinationPrefixListId,")
        append("gatewayId=$gatewayId,")
        append("routeTableId=$routeTableId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (destinationCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (destinationIpv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (destinationPrefixListId?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (routeTableId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2ReplaceRouteAction

        if (description != other.description) return false
        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (destinationIpv6CidrBlock != other.destinationIpv6CidrBlock) return false
        if (destinationPrefixListId != other.destinationPrefixListId) return false
        if (gatewayId != other.gatewayId) return false
        if (routeTableId != other.routeTableId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.fms.model.Ec2ReplaceRouteAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A description of the ReplaceRoute action in Amazon EC2.
         */
        public var description: kotlin.String? = null
        /**
         * Information about the IPv4 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.
         */
        public var destinationCidrBlock: kotlin.String? = null
        /**
         * Information about the IPv6 CIDR address block used for the destination match. The value that you provide must match the CIDR of an existing route in the table.
         */
        public var destinationIpv6CidrBlock: kotlin.String? = null
        /**
         * Information about the ID of the prefix list for the route.
         */
        public var destinationPrefixListId: kotlin.String? = null
        /**
         * Information about the ID of an internet gateway or virtual private gateway.
         */
        public var gatewayId: aws.sdk.kotlin.services.fms.model.ActionTarget? = null
        /**
         * Information about the ID of the route table.
         */
        public var routeTableId: aws.sdk.kotlin.services.fms.model.ActionTarget? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.fms.model.Ec2ReplaceRouteAction) : this() {
            this.description = x.description
            this.destinationCidrBlock = x.destinationCidrBlock
            this.destinationIpv6CidrBlock = x.destinationIpv6CidrBlock
            this.destinationPrefixListId = x.destinationPrefixListId
            this.gatewayId = x.gatewayId
            this.routeTableId = x.routeTableId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.fms.model.Ec2ReplaceRouteAction = Ec2ReplaceRouteAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.fms.model.ActionTarget] inside the given [block]
         */
        public fun gatewayId(block: aws.sdk.kotlin.services.fms.model.ActionTarget.Builder.() -> kotlin.Unit) {
            this.gatewayId = aws.sdk.kotlin.services.fms.model.ActionTarget.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.fms.model.ActionTarget] inside the given [block]
         */
        public fun routeTableId(block: aws.sdk.kotlin.services.fms.model.ActionTarget.Builder.() -> kotlin.Unit) {
            this.routeTableId = aws.sdk.kotlin.services.fms.model.ActionTarget.invoke(block)
        }
    }
}
